package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.JstSmsMessageDirectBatchsendResponse;

/**
 * TOP API: taobao.jst.sms.message.direct.batchsend request
 * 
 * @author top auto create
 * @since 1.0, 2022.06.21
 */
public class JstSmsMessageDirectBatchsendRequest extends BaseTaobaoRequest<JstSmsMessageDirectBatchsendResponse> {
	
	

	/** 
	* 短信扩展码（JSON字符串数组格式），拓展码个数需要和电话号码个数一致。
	 */
	private String extendNum;

	/** 
	* 如果传，必须是一个JSON对象格式的字符串。
	 */
	private String extraData;

	/** 
	* OAID批量发短信的入参，传该参数的时候rec_num不需要传，最大50个。
	 */
	private String oaids;

	/** 
	* OAID批量发短信时必传，为OAID一一对应的订单ID。
	 */
	private String orderIds;

	/** 
	* 短信接收号码，json格式，最多200个号码
	 */
	private String recNum;

	/** 
	* 短信签名（如果是通过OAID发送短信则签名需要是数组格式，数组长度需要和OAID数量保持一致。）
	 */
	private String signName;

	/** 
	* 模板参数替换方式："[{\"msg\":\"hello1\",\"date\":\"2021-12-03\"},{\"msg\":\"hello2\",\"date\":\"2021-12-04\"},{\"msg\":\"hello3\",\"date\":\"2021-12-05\"}]"
	 */
	private String smsContent;

	/** 
	* 短信模版Code（明文发送短信和OAID发送均不要传数组格式）
	 */
	private String smsTemplateCode;

	/** 
	* 废弃字段
	 */
	private String taskCode;

	/** 
	* 对于taskSign相同的请求平台认为是商家的同一次短信发送，可用于对OAID的明文号码去重。
	 */
	private String taskSign;

	/** 
	* 废弃字段
	 */
	private String url;

	public void setExtendNum(String extendNum) {
		this.extendNum = extendNum;
	}

	public String getExtendNum() {
		return this.extendNum;
	}

	public void setExtraData(String extraData) {
		this.extraData = extraData;
	}

	public String getExtraData() {
		return this.extraData;
	}

	public void setOaids(String oaids) {
		this.oaids = oaids;
	}

	public String getOaids() {
		return this.oaids;
	}

	public void setOrderIds(String orderIds) {
		this.orderIds = orderIds;
	}

	public String getOrderIds() {
		return this.orderIds;
	}

	public void setRecNum(String recNum) {
		this.recNum = recNum;
	}

	public String getRecNum() {
		return this.recNum;
	}

	public void setSignName(String signName) {
		this.signName = signName;
	}

	public String getSignName() {
		return this.signName;
	}

	public void setSmsContent(String smsContent) {
		this.smsContent = smsContent;
	}

	public String getSmsContent() {
		return this.smsContent;
	}

	public void setSmsTemplateCode(String smsTemplateCode) {
		this.smsTemplateCode = smsTemplateCode;
	}

	public String getSmsTemplateCode() {
		return this.smsTemplateCode;
	}

	public void setTaskCode(String taskCode) {
		this.taskCode = taskCode;
	}

	public String getTaskCode() {
		return this.taskCode;
	}

	public void setTaskSign(String taskSign) {
		this.taskSign = taskSign;
	}

	public String getTaskSign() {
		return this.taskSign;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getUrl() {
		return this.url;
	}

	public String getApiMethodName() {
		return "taobao.jst.sms.message.direct.batchsend";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("extend_num", this.extendNum);
		txtParams.put("extra_data", this.extraData);
		txtParams.put("oaids", this.oaids);
		txtParams.put("order_ids", this.orderIds);
		txtParams.put("rec_num", this.recNum);
		txtParams.put("sign_name", this.signName);
		txtParams.put("sms_content", this.smsContent);
		txtParams.put("sms_template_code", this.smsTemplateCode);
		txtParams.put("task_code", this.taskCode);
		txtParams.put("task_sign", this.taskSign);
		txtParams.put("url", this.url);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<JstSmsMessageDirectBatchsendResponse> getResponseClass() {
		return JstSmsMessageDirectBatchsendResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(signName, "signName");
		RequestCheckUtils.checkNotEmpty(smsTemplateCode, "smsTemplateCode");
	}
	

}