package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.json.JSONValidatingReader;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.JstSmsMessageSendResponse;

/**
 * TOP API: taobao.jst.sms.message.send request
 * 
 * @author top auto create
 * @since 1.0, 2021.01.04
 */
public class JstSmsMessageSendRequest extends BaseTaobaoRequest<JstSmsMessageSendResponse> {
	
	

	/** 
	* 短信发送请求
	 */
	private String sendMessageRequest;

	public void setSendMessageRequest(String sendMessageRequest) {
		this.sendMessageRequest = sendMessageRequest;
	}

	public void setSendMessageRequest(SendMessageRequest sendMessageRequest) {
		this.sendMessageRequest = new JSONWriter(false,true).write(sendMessageRequest);
	}

	public String getSendMessageRequest() {
		return this.sendMessageRequest;
	}

	public String getApiMethodName() {
		return "taobao.jst.sms.message.send";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("send_message_request", this.sendMessageRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<JstSmsMessageSendResponse> getResponseClass() {
		return JstSmsMessageSendResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 短信发送请求
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class SendMessageRequest extends TaobaoObject {

	private static final long serialVersionUID = 8647637216166479963L;

	/**
		 * 短信批次号
		 */
		@ApiField("batch_number")
		private String batchNumber;
		/**
		 * 渠道类型
		 */
		@ApiField("channel_type")
		private String channelType;
		/**
		 * 拓展信息
		 */
		@ApiField("extend")
		private String extend;
		/**
		 * 拓展Code
		 */
		@ApiField("extend_code")
		private String extendCode;
		/**
		 * 拓展Name
		 */
		@ApiField("extend_name")
		private String extendName;
		/**
		 * 短信内容参数, ${url}会被入参url的值替换掉
		 */
		@ApiField("params")
		private String params;
		/**
		 * 手机号码
		 */
		@ApiField("phone_number")
		private String phoneNumber;
		/**
		 * 短信签名
		 */
		@ApiField("sms_free_sign_name")
		private String smsFreeSignName;
		/**
		 * 短信类型
		 */
		@ApiField("sms_type")
		private String smsType;
		/**
		 * 短信人群tag
		 */
		@ApiField("tag")
		private String tag;
		/**
		 * 短信模版Code
		 */
		@ApiField("template_code")
		private String templateCode;
		/**
		 * 标记字段
		 */
		@ApiField("tool_flag")
		private String toolFlag;
		/**
		 * 商品H5详情页，如果不传则没有短信效果数据
		 */
		@ApiField("url")
		private String url;
	

	public String getBatchNumber() {
			return this.batchNumber;
		}
		public void setBatchNumber(String batchNumber) {
			this.batchNumber = batchNumber;
		}
		public String getChannelType() {
			return this.channelType;
		}
		public void setChannelType(String channelType) {
			this.channelType = channelType;
		}
		public String getExtend() {
			return this.extend;
		}
		public void setExtend(String extend) {
			this.extend = extend;
		}
		public String getExtendCode() {
			return this.extendCode;
		}
		public void setExtendCode(String extendCode) {
			this.extendCode = extendCode;
		}
		public String getExtendName() {
			return this.extendName;
		}
		public void setExtendName(String extendName) {
			this.extendName = extendName;
		}
		public String getParams() {
			return this.params;
		}
		public void setParams(String params) {
			this.params = params;
		}
		public void setParamsString(String params) {
			this.params = params;
		}
		
		public String getPhoneNumber() {
			return this.phoneNumber;
		}
		public void setPhoneNumber(String phoneNumber) {
			this.phoneNumber = phoneNumber;
		}
		public String getSmsFreeSignName() {
			return this.smsFreeSignName;
		}
		public void setSmsFreeSignName(String smsFreeSignName) {
			this.smsFreeSignName = smsFreeSignName;
		}
		public String getSmsType() {
			return this.smsType;
		}
		public void setSmsType(String smsType) {
			this.smsType = smsType;
		}
		public String getTag() {
			return this.tag;
		}
		public void setTag(String tag) {
			this.tag = tag;
		}
		public String getTemplateCode() {
			return this.templateCode;
		}
		public void setTemplateCode(String templateCode) {
			this.templateCode = templateCode;
		}
		public String getToolFlag() {
			return this.toolFlag;
		}
		public void setToolFlag(String toolFlag) {
			this.toolFlag = toolFlag;
		}
		public String getUrl() {
			return this.url;
		}
		public void setUrl(String url) {
			this.url = url;
		}

}


}