package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.JstSmsMessageShorturlCreateResponse;

/**
 * TOP API: taobao.jst.sms.message.shorturl.create request
 * 
 * @author top auto create
 * @since 1.0, 2021.01.04
 */
public class JstSmsMessageShorturlCreateRequest extends BaseTaobaoRequest<JstSmsMessageShorturlCreateResponse> {
	
	

	/** 
	* 批次号
	 */
	private String batchNumber;

	/** 
	* 是否需要https前缀： true-要  false-不要
	 */
	private Boolean needHttpsPrefix;

	/** 
	* 人群标签
	 */
	private String tag;

	/** 
	* 商品或者店铺的H5地址，只支持长链
	 */
	private String url;

	public void setBatchNumber(String batchNumber) {
		this.batchNumber = batchNumber;
	}

	public String getBatchNumber() {
		return this.batchNumber;
	}

	public void setNeedHttpsPrefix(Boolean needHttpsPrefix) {
		this.needHttpsPrefix = needHttpsPrefix;
	}

	public Boolean getNeedHttpsPrefix() {
		return this.needHttpsPrefix;
	}

	public void setTag(String tag) {
		this.tag = tag;
	}

	public String getTag() {
		return this.tag;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getUrl() {
		return this.url;
	}

	public String getApiMethodName() {
		return "taobao.jst.sms.message.shorturl.create";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("batch_number", this.batchNumber);
		txtParams.put("need_https_prefix", this.needHttpsPrefix);
		txtParams.put("tag", this.tag);
		txtParams.put("url", this.url);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<JstSmsMessageShorturlCreateResponse> getResponseClass() {
		return JstSmsMessageShorturlCreateResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(batchNumber, "batchNumber");
		RequestCheckUtils.checkNotEmpty(tag, "tag");
		RequestCheckUtils.checkNotEmpty(url, "url");
	}
	

}