package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.JstSmsMessageShorturlQueryResponse;

/**
 * TOP API: taobao.jst.sms.message.shorturl.query request
 * 
 * @author top auto create
 * @since 1.0, 2021.01.13
 */
public class JstSmsMessageShorturlQueryRequest extends BaseTaobaoRequest<JstSmsMessageShorturlQueryResponse> {
	
	

	/** 
	* 短链名，即域名后的字符串
	 */
	private String shortName;

	public void setShortName(String shortName) {
		this.shortName = shortName;
	}

	public String getShortName() {
		return this.shortName;
	}

	public String getApiMethodName() {
		return "taobao.jst.sms.message.shorturl.query";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("short_name", this.shortName);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<JstSmsMessageShorturlQueryResponse> getResponseClass() {
		return JstSmsMessageShorturlQueryResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(shortName, "shortName");
	}
	

}