package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.json.JSONValidatingReader;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.JstSmsOaidMessageSendResponse;

/**
 * TOP API: taobao.jst.sms.oaid.message.send request
 * 
 * @author top auto create
 * @since 1.0, 2021.07.12
 */
public class JstSmsOaidMessageSendRequest extends BaseTaobaoRequest<JstSmsOaidMessageSendResponse> {
	
	

	/** 
	* 单个OAID发送短信的入参
	 */
	private String paramSendMessageByOAIDRequest;

	public void setParamSendMessageByOAIDRequest(String paramSendMessageByOAIDRequest) {
		this.paramSendMessageByOAIDRequest = paramSendMessageByOAIDRequest;
	}

	public void setParamSendMessageByOAIDRequest(SendMessageByOaidRequest paramSendMessageByOAIDRequest) {
		this.paramSendMessageByOAIDRequest = new JSONWriter(false,true).write(paramSendMessageByOAIDRequest);
	}

	public String getParamSendMessageByOAIDRequest() {
		return this.paramSendMessageByOAIDRequest;
	}

	public String getApiMethodName() {
		return "taobao.jst.sms.oaid.message.send";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param_send_message_by_o_a_i_d_request", this.paramSendMessageByOAIDRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<JstSmsOaidMessageSendResponse> getResponseClass() {
		return JstSmsOaidMessageSendResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 单个OAID发送短信的入参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class SendMessageByOaidRequest extends TaobaoObject {

	private static final long serialVersionUID = 5436143491758289567L;

	/**
		 * 是否需要返回附加信息
		 */
		@ApiField("additional_info")
		private Boolean additionalInfo;
		/**
		 * 拓展信息
		 */
		@ApiField("extend")
		private String extend;
		/**
		 * 拓展Code
		 */
		@ApiField("extend_code")
		private String extendCode;
		/**
		 * 拓展Name
		 */
		@ApiField("extend_name")
		private String extendName;
		/**
		 * OAID
		 */
		@ApiField("oaid")
		private String oaid;
		/**
		 * 订单号
		 */
		@ApiField("order_id")
		private String orderId;
		/**
		 * 短信占位符，替换短信模板里的占位符
		 */
		@ApiField("params")
		private String params;
		/**
		 * 短信签名
		 */
		@ApiField("sms_free_sign_name")
		private String smsFreeSignName;
		/**
		 * 短信模板
		 */
		@ApiField("template_code")
		private String templateCode;
	

	public Boolean getAdditionalInfo() {
			return this.additionalInfo;
		}
		public void setAdditionalInfo(Boolean additionalInfo) {
			this.additionalInfo = additionalInfo;
		}
		public String getExtend() {
			return this.extend;
		}
		public void setExtend(String extend) {
			this.extend = extend;
		}
		public String getExtendCode() {
			return this.extendCode;
		}
		public void setExtendCode(String extendCode) {
			this.extendCode = extendCode;
		}
		public String getExtendName() {
			return this.extendName;
		}
		public void setExtendName(String extendName) {
			this.extendName = extendName;
		}
		public String getOaid() {
			return this.oaid;
		}
		public void setOaid(String oaid) {
			this.oaid = oaid;
		}
		public String getOrderId() {
			return this.orderId;
		}
		public void setOrderId(String orderId) {
			this.orderId = orderId;
		}
		public String getParams() {
			return this.params;
		}
		public void setParams(String params) {
			this.params = params;
		}
		public void setParamsString(String params) {
			this.params = params;
		}
		
		public String getSmsFreeSignName() {
			return this.smsFreeSignName;
		}
		public void setSmsFreeSignName(String smsFreeSignName) {
			this.smsFreeSignName = smsFreeSignName;
		}
		public String getTemplateCode() {
			return this.templateCode;
		}
		public void setTemplateCode(String templateCode) {
			this.templateCode = templateCode;
		}

}


}