package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.JstSmsSignnameDeleteResponse;

/**
 * TOP API: taobao.jst.sms.signname.delete request
 * 
 * @author top auto create
 * @since 1.0, 2021.12.28
 */
public class JstSmsSignnameDeleteRequest extends BaseTaobaoRequest<JstSmsSignnameDeleteResponse> {
	
	

	/** 
	* 删除签名入参
	 */
	private String deleteSmsSignRequest;

	public void setDeleteSmsSignRequest(String deleteSmsSignRequest) {
		this.deleteSmsSignRequest = deleteSmsSignRequest;
	}

	public void setDeleteSmsSignRequest(TopDeleteSmsSignRequest deleteSmsSignRequest) {
		this.deleteSmsSignRequest = new JSONWriter(false,true).write(deleteSmsSignRequest);
	}

	public String getDeleteSmsSignRequest() {
		return this.deleteSmsSignRequest;
	}

	public String getApiMethodName() {
		return "taobao.jst.sms.signname.delete";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("delete_sms_sign_request", this.deleteSmsSignRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<JstSmsSignnameDeleteResponse> getResponseClass() {
		return JstSmsSignnameDeleteResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 删除签名入参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopDeleteSmsSignRequest extends TaobaoObject {

	private static final long serialVersionUID = 8413227199774723812L;

	/**
		 * 待删除的签名
		 */
		@ApiField("sign_name")
		private String signName;
	

	public String getSignName() {
			return this.signName;
		}
		public void setSignName(String signName) {
			this.signName = signName;
		}

}


}