package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.JstSmsSignnameModifyResponse;

/**
 * TOP API: taobao.jst.sms.signname.modify request
 * 
 * @author top auto create
 * @since 1.0, 2021.12.28
 */
public class JstSmsSignnameModifyRequest extends BaseTaobaoRequest<JstSmsSignnameModifyResponse> {
	
	

	/** 
	* 修改签名入参
	 */
	private String modifySmsSignRequest;

	public void setModifySmsSignRequest(String modifySmsSignRequest) {
		this.modifySmsSignRequest = modifySmsSignRequest;
	}

	public void setModifySmsSignRequest(TopModifySmsSignRequest modifySmsSignRequest) {
		this.modifySmsSignRequest = new JSONWriter(false,true).write(modifySmsSignRequest);
	}

	public String getModifySmsSignRequest() {
		return this.modifySmsSignRequest;
	}

	public String getApiMethodName() {
		return "taobao.jst.sms.signname.modify";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("modify_sms_sign_request", this.modifySmsSignRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<JstSmsSignnameModifyResponse> getResponseClass() {
		return JstSmsSignnameModifyResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 上传的证明文件
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class SmsFileContentDTO extends TaobaoObject {

	private static final long serialVersionUID = 3593752967256621255L;

	/**
		 * 文件Base64转码后的字符串
		 */
		@ApiField("file_contents")
		private String fileContents;
		/**
		 * 文件名称
		 */
		@ApiField("file_name")
		private String fileName;
		/**
		 * 文件大小
		 */
		@ApiField("file_size")
		private Long fileSize;
		/**
		 * 文件后缀名
		 */
		@ApiField("file_suffix")
		private String fileSuffix;
	

	public String getFileContents() {
			return this.fileContents;
		}
		public void setFileContents(String fileContents) {
			this.fileContents = fileContents;
		}
		public String getFileName() {
			return this.fileName;
		}
		public void setFileName(String fileName) {
			this.fileName = fileName;
		}
		public Long getFileSize() {
			return this.fileSize;
		}
		public void setFileSize(Long fileSize) {
			this.fileSize = fileSize;
		}
		public String getFileSuffix() {
			return this.fileSuffix;
		}
		public void setFileSuffix(String fileSuffix) {
			this.fileSuffix = fileSuffix;
		}

}

	/**
 * 修改签名入参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopModifySmsSignRequest extends TaobaoObject {

	private static final long serialVersionUID = 4165423652536137441L;

	/**
		 * 请输入签名用途（必填）、企业官网链接（可提升通过率）
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 上传的证明文件
		 */
		@ApiListField("sign_file_list")
		@ApiField("sms_file_content_d_t_o")
		private List<SmsFileContentDTO> signFileList;
		/**
		 * 要修改的签名,不能修改签名
		 */
		@ApiField("sign_name")
		private String signName;
		/**
		 * 0--企事业单位的全程或简称   1--已备案网站  2--已上线APP  3--公众号或小程序 4--电商平台店铺名 5--已注册商标名
		 */
		@ApiField("sign_source")
		private Long signSource;
	

	public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public List<SmsFileContentDTO> getSignFileList() {
			return this.signFileList;
		}
		public void setSignFileList(List<SmsFileContentDTO> signFileList) {
			this.signFileList = signFileList;
		}
		public String getSignName() {
			return this.signName;
		}
		public void setSignName(String signName) {
			this.signName = signName;
		}
		public Long getSignSource() {
			return this.signSource;
		}
		public void setSignSource(Long signSource) {
			this.signSource = signSource;
		}

}


}