package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.JstSmsSignnameQueryResponse;

/**
 * TOP API: taobao.jst.sms.signname.query request
 * 
 * @author top auto create
 * @since 1.0, 2021.12.28
 */
public class JstSmsSignnameQueryRequest extends BaseTaobaoRequest<JstSmsSignnameQueryResponse> {
	
	

	/** 
	* 签名查询的入参
	 */
	private String querySmsSignRequest;

	public void setQuerySmsSignRequest(String querySmsSignRequest) {
		this.querySmsSignRequest = querySmsSignRequest;
	}

	public void setQuerySmsSignRequest(TopQuerySmsSignRequest querySmsSignRequest) {
		this.querySmsSignRequest = new JSONWriter(false,true).write(querySmsSignRequest);
	}

	public String getQuerySmsSignRequest() {
		return this.querySmsSignRequest;
	}

	public String getApiMethodName() {
		return "taobao.jst.sms.signname.query";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("query_sms_sign_request", this.querySmsSignRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<JstSmsSignnameQueryResponse> getResponseClass() {
		return JstSmsSignnameQueryResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 签名查询的入参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopQuerySmsSignRequest extends TaobaoObject {

	private static final long serialVersionUID = 8244121982534842944L;

	/**
		 * 要查询的签名
		 */
		@ApiField("sign_name")
		private String signName;
	

	public String getSignName() {
			return this.signName;
		}
		public void setSignName(String signName) {
			this.signName = signName;
		}

}


}