package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.JstSmsSignnameReportResponse;

/**
 * TOP API: taobao.jst.sms.signname.report request
 * 
 * @author top auto create
 * @since 1.0, 2021.12.14
 */
public class JstSmsSignnameReportRequest extends BaseTaobaoRequest<JstSmsSignnameReportResponse> {
	
	

	/** 
	* 上传签名入参
	 */
	private String smsSignNameRequest;

	public void setSmsSignNameRequest(String smsSignNameRequest) {
		this.smsSignNameRequest = smsSignNameRequest;
	}

	public void setSmsSignNameRequest(List<SmsSignNameRequest> smsSignNameRequest) {
		this.smsSignNameRequest = new JSONWriter(false,true).write(smsSignNameRequest);
	}

	public String getSmsSignNameRequest() {
		return this.smsSignNameRequest;
	}

	public String getApiMethodName() {
		return "taobao.jst.sms.signname.report";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("sms_sign_name_request", this.smsSignNameRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<JstSmsSignnameReportResponse> getResponseClass() {
		return JstSmsSignnameReportResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 上传签名入参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class SmsSignNameRequest extends TaobaoObject {

	private static final long serialVersionUID = 8168282665556391195L;

	/**
		 * 描述信息
		 */
		@ApiField("description")
		private String description;
		/**
		 * 短信签名
		 */
		@ApiField("sign_name")
		private String signName;
	

	public String getDescription() {
			return this.description;
		}
		public void setDescription(String description) {
			this.description = description;
		}
		public String getSignName() {
			return this.signName;
		}
		public void setSignName(String signName) {
			this.signName = signName;
		}

}


}