package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.JstSmsTaskCreateResponse;

/**
 * TOP API: taobao.jst.sms.task.create request
 * 
 * @author top auto create
 * @since 1.0, 2021.01.12
 */
public class JstSmsTaskCreateRequest extends BaseTaobaoRequest<JstSmsTaskCreateResponse> {
	
	

	/** 
	* 创建任务的入参
	 */
	private String paramCreateSmsTaskRequest;

	public void setParamCreateSmsTaskRequest(String paramCreateSmsTaskRequest) {
		this.paramCreateSmsTaskRequest = paramCreateSmsTaskRequest;
	}

	public void setParamCreateSmsTaskRequest(CreateSmsTaskRequest paramCreateSmsTaskRequest) {
		this.paramCreateSmsTaskRequest = new JSONWriter(false,true).write(paramCreateSmsTaskRequest);
	}

	public String getParamCreateSmsTaskRequest() {
		return this.paramCreateSmsTaskRequest;
	}

	public String getApiMethodName() {
		return "taobao.jst.sms.task.create";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param_create_sms_task_request", this.paramCreateSmsTaskRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<JstSmsTaskCreateResponse> getResponseClass() {
		return JstSmsTaskCreateResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 创建任务的入参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class CreateSmsTaskRequest extends TaobaoObject {

	private static final long serialVersionUID = 5676364818315969744L;

	/**
		 * 权益短信必须是两个文案，其他类型短信为一个文案，文案中必须带${url}占位符，普通短信文案在第一个，权益短信文案在第二个，请严格按照顺序提交
		 */
		@ApiListField("contents")
		@ApiField("string")
		private List<String> contents;
		/**
		 * 公众号短信必须是两个签名，其他类型短信为一个签名，普通短信的签名在第一个，公众号短信的签名在第二个，请严格按照顺序提交
		 */
		@ApiListField("sign_names")
		@ApiField("string")
		private List<String> signNames;
		/**
		 * 任务对应的短信类型 ：1--数字短信  2--权益短信  3--公众号短信
		 */
		@ApiField("sms_type")
		private Long smsType;
		/**
		 * 任务Code，系统分配的，创建任务不需要传，更新任务需要传对应的Code（只能更新短信文案、短信签名、短信模板）
		 */
		@ApiField("task_code")
		private String taskCode;
		/**
		 * 数字短信必须是两个模板，其他类型短信为一个模板，普通短信模板在第一个，数字短信的模板在第二个，请严格按照顺序提交
		 */
		@ApiListField("template_codes")
		@ApiField("string")
		private List<String> templateCodes;
		/**
		 * 商品详情页或店铺页H5长链地址，不能是短链
		 */
		@ApiField("url")
		private String url;
	

	public List<String> getContents() {
			return this.contents;
		}
		public void setContents(List<String> contents) {
			this.contents = contents;
		}
		public List<String> getSignNames() {
			return this.signNames;
		}
		public void setSignNames(List<String> signNames) {
			this.signNames = signNames;
		}
		public Long getSmsType() {
			return this.smsType;
		}
		public void setSmsType(Long smsType) {
			this.smsType = smsType;
		}
		public String getTaskCode() {
			return this.taskCode;
		}
		public void setTaskCode(String taskCode) {
			this.taskCode = taskCode;
		}
		public List<String> getTemplateCodes() {
			return this.templateCodes;
		}
		public void setTemplateCodes(List<String> templateCodes) {
			this.templateCodes = templateCodes;
		}
		public String getUrl() {
			return this.url;
		}
		public void setUrl(String url) {
			this.url = url;
		}

}


}