package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.JstSmsTemplateCreateResponse;

/**
 * TOP API: taobao.jst.sms.template.create request
 * 
 * @author top auto create
 * @since 1.0, 2021.12.28
 */
public class JstSmsTemplateCreateRequest extends BaseTaobaoRequest<JstSmsTemplateCreateResponse> {
	
	

	/** 
	* 申请模板入参
	 */
	private String smsTemplateForIsvRequest;

	public void setSmsTemplateForIsvRequest(String smsTemplateForIsvRequest) {
		this.smsTemplateForIsvRequest = smsTemplateForIsvRequest;
	}

	public void setSmsTemplateForIsvRequest(AddSmsTemplateForIsvRequest smsTemplateForIsvRequest) {
		this.smsTemplateForIsvRequest = new JSONWriter(false,true).write(smsTemplateForIsvRequest);
	}

	public String getSmsTemplateForIsvRequest() {
		return this.smsTemplateForIsvRequest;
	}

	public String getApiMethodName() {
		return "taobao.jst.sms.template.create";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("sms_template_for_isv_request", this.smsTemplateForIsvRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<JstSmsTemplateCreateResponse> getResponseClass() {
		return JstSmsTemplateCreateResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 上传文件
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class DigitalSmsTemplateContentDTO extends TaobaoObject {

	private static final long serialVersionUID = 8236546129826516977L;

	/**
		 * 文件Base64转码后的字符串
		 */
		@ApiField("file_contents")
		private String fileContents;
		/**
		 * 文件名称
		 */
		@ApiField("file_name")
		private String fileName;
		/**
		 * 文件大小
		 */
		@ApiField("file_size")
		private Long fileSize;
		/**
		 * 文件后缀名
		 */
		@ApiField("file_suffix")
		private String fileSuffix;
	

	public String getFileContents() {
			return this.fileContents;
		}
		public void setFileContents(String fileContents) {
			this.fileContents = fileContents;
		}
		public String getFileName() {
			return this.fileName;
		}
		public void setFileName(String fileName) {
			this.fileName = fileName;
		}
		public Long getFileSize() {
			return this.fileSize;
		}
		public void setFileSize(Long fileSize) {
			this.fileSize = fileSize;
		}
		public String getFileSuffix() {
			return this.fileSuffix;
		}
		public void setFileSuffix(String fileSuffix) {
			this.fileSuffix = fileSuffix;
		}

}

	/**
 * 申请模板入参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class AddSmsTemplateForIsvRequest extends TaobaoObject {

	private static final long serialVersionUID = 5571224457239415745L;

	/**
		 * 使用场景说明
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 模板内容，占位符用${}标识
		 */
		@ApiField("template_content")
		private String templateContent;
		/**
		 * 上传文件
		 */
		@ApiListField("template_infos")
		@ApiField("digital_sms_template_content_d_t_o")
		private List<DigitalSmsTemplateContentDTO> templateInfos;
		/**
		 * 模板名称
		 */
		@ApiField("template_name")
		private String templateName;
		/**
		 * 0--验证码 1--短信通知 2-- 推广短信 3--国际港澳台消息
		 */
		@ApiField("template_type")
		private Long templateType;
		/**
		 * NORMAL -- 普通模板  DIGITAL--数字短信模板
		 */
		@ApiField("template_type_class")
		private String templateTypeClass;
	

	public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getTemplateContent() {
			return this.templateContent;
		}
		public void setTemplateContent(String templateContent) {
			this.templateContent = templateContent;
		}
		public List<DigitalSmsTemplateContentDTO> getTemplateInfos() {
			return this.templateInfos;
		}
		public void setTemplateInfos(List<DigitalSmsTemplateContentDTO> templateInfos) {
			this.templateInfos = templateInfos;
		}
		public String getTemplateName() {
			return this.templateName;
		}
		public void setTemplateName(String templateName) {
			this.templateName = templateName;
		}
		public Long getTemplateType() {
			return this.templateType;
		}
		public void setTemplateType(Long templateType) {
			this.templateType = templateType;
		}
		public String getTemplateTypeClass() {
			return this.templateTypeClass;
		}
		public void setTemplateTypeClass(String templateTypeClass) {
			this.templateTypeClass = templateTypeClass;
		}

}


}