package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.JstSmsTemplateDeleteResponse;

/**
 * TOP API: taobao.jst.sms.template.delete request
 * 
 * @author top auto create
 * @since 1.0, 2021.12.28
 */
public class JstSmsTemplateDeleteRequest extends BaseTaobaoRequest<JstSmsTemplateDeleteResponse> {
	
	

	/** 
	* 删除模板的入参
	 */
	private String deleteSmsTemplateRequest;

	public void setDeleteSmsTemplateRequest(String deleteSmsTemplateRequest) {
		this.deleteSmsTemplateRequest = deleteSmsTemplateRequest;
	}

	public void setDeleteSmsTemplateRequest(TopDeleteSmsTemplateRequest deleteSmsTemplateRequest) {
		this.deleteSmsTemplateRequest = new JSONWriter(false,true).write(deleteSmsTemplateRequest);
	}

	public String getDeleteSmsTemplateRequest() {
		return this.deleteSmsTemplateRequest;
	}

	public String getApiMethodName() {
		return "taobao.jst.sms.template.delete";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("delete_sms_template_request", this.deleteSmsTemplateRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<JstSmsTemplateDeleteResponse> getResponseClass() {
		return JstSmsTemplateDeleteResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 删除模板的入参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopDeleteSmsTemplateRequest extends TaobaoObject {

	private static final long serialVersionUID = 6125191147457616558L;

	/**
		 * 待删除的模板code
		 */
		@ApiField("template_code")
		private String templateCode;
	

	public String getTemplateCode() {
			return this.templateCode;
		}
		public void setTemplateCode(String templateCode) {
			this.templateCode = templateCode;
		}

}


}