package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.JstSmsTemplateModifyResponse;

/**
 * TOP API: taobao.jst.sms.template.modify request
 * 
 * @author top auto create
 * @since 1.0, 2021.12.28
 */
public class JstSmsTemplateModifyRequest extends BaseTaobaoRequest<JstSmsTemplateModifyResponse> {
	
	

	/** 
	* 修改模板的入参
	 */
	private String modifySmsTemplateRequest;

	public void setModifySmsTemplateRequest(String modifySmsTemplateRequest) {
		this.modifySmsTemplateRequest = modifySmsTemplateRequest;
	}

	public void setModifySmsTemplateRequest(TopModifySmsTemplateRequest modifySmsTemplateRequest) {
		this.modifySmsTemplateRequest = new JSONWriter(false,true).write(modifySmsTemplateRequest);
	}

	public String getModifySmsTemplateRequest() {
		return this.modifySmsTemplateRequest;
	}

	public String getApiMethodName() {
		return "taobao.jst.sms.template.modify";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("modify_sms_template_request", this.modifySmsTemplateRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<JstSmsTemplateModifyResponse> getResponseClass() {
		return JstSmsTemplateModifyResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 修改模板的入参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopModifySmsTemplateRequest extends TaobaoObject {

	private static final long serialVersionUID = 2299922384132776483L;

	/**
		 * 使用场景说明，可以修改
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 不能修改
		 */
		@ApiField("template_code")
		private String templateCode;
		/**
		 * 模板内容，占位符用${}标识，可以修改
		 */
		@ApiField("template_content")
		private String templateContent;
		/**
		 * 模板名称，可以修改
		 */
		@ApiField("template_name")
		private String templateName;
		/**
		 * 不能修改
		 */
		@ApiField("template_type")
		private Long templateType;
	

	public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getTemplateCode() {
			return this.templateCode;
		}
		public void setTemplateCode(String templateCode) {
			this.templateCode = templateCode;
		}
		public String getTemplateContent() {
			return this.templateContent;
		}
		public void setTemplateContent(String templateContent) {
			this.templateContent = templateContent;
		}
		public String getTemplateName() {
			return this.templateName;
		}
		public void setTemplateName(String templateName) {
			this.templateName = templateName;
		}
		public Long getTemplateType() {
			return this.templateType;
		}
		public void setTemplateType(Long templateType) {
			this.templateType = templateType;
		}

}


}