package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.JstSmsTemplateQueryResponse;

/**
 * TOP API: taobao.jst.sms.template.query request
 * 
 * @author top auto create
 * @since 1.0, 2021.12.28
 */
public class JstSmsTemplateQueryRequest extends BaseTaobaoRequest<JstSmsTemplateQueryResponse> {
	
	

	/** 
	* 查询短信模板的入参
	 */
	private String querySmsTemplateRequest;

	public void setQuerySmsTemplateRequest(String querySmsTemplateRequest) {
		this.querySmsTemplateRequest = querySmsTemplateRequest;
	}

	public void setQuerySmsTemplateRequest(TopQuerySmsTemplateRequest querySmsTemplateRequest) {
		this.querySmsTemplateRequest = new JSONWriter(false,true).write(querySmsTemplateRequest);
	}

	public String getQuerySmsTemplateRequest() {
		return this.querySmsTemplateRequest;
	}

	public String getApiMethodName() {
		return "taobao.jst.sms.template.query";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("query_sms_template_request", this.querySmsTemplateRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<JstSmsTemplateQueryResponse> getResponseClass() {
		return JstSmsTemplateQueryResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 查询短信模板的入参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopQuerySmsTemplateRequest extends TaobaoObject {

	private static final long serialVersionUID = 2442579365397112676L;

	/**
		 * 要查询的模板CODE
		 */
		@ApiField("template_code")
		private String templateCode;
	

	public String getTemplateCode() {
			return this.templateCode;
		}
		public void setTemplateCode(String templateCode) {
			this.templateCode = templateCode;
		}

}


}