package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.JstSmsTemplateReportResponse;

/**
 * TOP API: taobao.jst.sms.template.report request
 * 
 * @author top auto create
 * @since 1.0, 2021.12.14
 */
public class JstSmsTemplateReportRequest extends BaseTaobaoRequest<JstSmsTemplateReportResponse> {
	
	

	/** 
	* 存量短信模板上报入参
	 */
	private String smsTemplateRequest;

	public void setSmsTemplateRequest(String smsTemplateRequest) {
		this.smsTemplateRequest = smsTemplateRequest;
	}

	public void setSmsTemplateRequest(List<SmsTemplateRequest> smsTemplateRequest) {
		this.smsTemplateRequest = new JSONWriter(false,true).write(smsTemplateRequest);
	}

	public String getSmsTemplateRequest() {
		return this.smsTemplateRequest;
	}

	public String getApiMethodName() {
		return "taobao.jst.sms.template.report";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("sms_template_request", this.smsTemplateRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<JstSmsTemplateReportResponse> getResponseClass() {
		return JstSmsTemplateReportResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 存量短信模板上报入参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class SmsTemplateRequest extends TaobaoObject {

	private static final long serialVersionUID = 4568935618527222361L;

	/**
		 * 描述信息
		 */
		@ApiField("desc")
		private String desc;
		/**
		 * 1-- 普通模板  2--数字短信模板
		 */
		@ApiField("template_class")
		private String templateClass;
		/**
		 * 模板CODE
		 */
		@ApiField("template_code")
		private String templateCode;
		/**
		 * 模板内容
		 */
		@ApiField("template_content")
		private String templateContent;
		/**
		 * 模板名称
		 */
		@ApiField("template_name")
		private String templateName;
		/**
		 * 0--验证码 1--短信通知 2-- 推广短信 3--国际港澳台消息
		 */
		@ApiField("template_type")
		private String templateType;
	

	public String getDesc() {
			return this.desc;
		}
		public void setDesc(String desc) {
			this.desc = desc;
		}
		public String getTemplateClass() {
			return this.templateClass;
		}
		public void setTemplateClass(String templateClass) {
			this.templateClass = templateClass;
		}
		public String getTemplateCode() {
			return this.templateCode;
		}
		public void setTemplateCode(String templateCode) {
			this.templateCode = templateCode;
		}
		public String getTemplateContent() {
			return this.templateContent;
		}
		public void setTemplateContent(String templateContent) {
			this.templateContent = templateContent;
		}
		public String getTemplateName() {
			return this.templateName;
		}
		public void setTemplateName(String templateName) {
			this.templateName = templateName;
		}
		public String getTemplateType() {
			return this.templateType;
		}
		public void setTemplateType(String templateType) {
			this.templateType = templateType;
		}

}


}