package com.taobao.api.request;

import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.JushitaJdpUserDeleteResponse;

/**
 * TOP API: taobao.jushita.jdp.user.delete request
 * 
 * @author top auto create
 * @since 1.0, 2024.01.23
 */
public class JushitaJdpUserDeleteRequest extends BaseTaobaoRequest<JushitaJdpUserDeleteResponse> {
	
	

	/** 
	* 要删除用户的昵称
	 */
	private String nick;

	/** 
	* 要删除用户的openuid
	 */
	private String openUid;

	public void setNick(String nick) {
		this.nick = nick;
	}

	public String getNick() {
		return this.nick;
	}

	public void setOpenUid(String openUid) {
		this.openUid = openUid;
	}

	public String getOpenUid() {
		return this.openUid;
	}

	public String getApiMethodName() {
		return "taobao.jushita.jdp.user.delete";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("nick", this.nick);
		txtParams.put("open_uid", this.openUid);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<JushitaJdpUserDeleteResponse> getResponseClass() {
		return JushitaJdpUserDeleteResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	

}