package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.LogisticsOfflineSendCsorderResponse;

/**
 * TOP API: taobao.logistics.offline.send.csorder request
 * 
 * @author top auto create
 * @since 1.0, 2022.07.15
 */
public class LogisticsOfflineSendCsorderRequest extends BaseTaobaoRequest<LogisticsOfflineSendCsorderResponse> {
	
	

	/** 
	* 请求参数
	 */
	private String req;

	public void setReq(String req) {
		this.req = req;
	}

	public void setReq(OrderPerformanceOperationRequestVO req) {
		this.req = new JSONWriter(false,true).write(req);
	}

	public String getReq() {
		return this.req;
	}

	public String getApiMethodName() {
		return "taobao.logistics.offline.send.csorder";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("req", this.req);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<LogisticsOfflineSendCsorderResponse> getResponseClass() {
		return LogisticsOfflineSendCsorderResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 请求参数
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class OrderPerformanceOperationRequestVO extends TaobaoObject {

	private static final long serialVersionUID = 2187785334266928514L;

	/**
		 * 淘宝订单号
		 */
		@ApiField("biz_order_id")
		private Long bizOrderId;
		/**
		 * 端类型1为钉钉，2为PC
		 */
		@ApiField("client_type")
		private Long clientType;
		/**
		 * 物流公司编码，由菜鸟生成
		 */
		@ApiField("company_code")
		private String companyCode;
		/**
		 * 物流公司名称
		 */
		@ApiField("company_name")
		private String companyName;
		/**
		 * 企业id
		 */
		@ApiField("ent_uic_id")
		private Long entUicId;
		/**
		 * 物流公司id，由菜鸟生成
		 */
		@ApiField("logistics_company_id")
		private Long logisticsCompanyId;
		/**
		 * 物流单号
		 */
		@ApiField("mail_no")
		private String mailNo;
		/**
		 * 加密id
		 */
		@ApiField("openid")
		private String openid;
		/**
		 * 当前用户登录角色:柜员 or 店长
		 */
		@ApiField("role_code")
		private String roleCode;
		/**
		 * 门店id
		 */
		@ApiField("store_id")
		private Long storeId;
		/**
		 * 门店自送
		 */
		@ApiField("store_self_delivery")
		private Boolean storeSelfDelivery;
	

	public Long getBizOrderId() {
			return this.bizOrderId;
		}
		public void setBizOrderId(Long bizOrderId) {
			this.bizOrderId = bizOrderId;
		}
		public Long getClientType() {
			return this.clientType;
		}
		public void setClientType(Long clientType) {
			this.clientType = clientType;
		}
		public String getCompanyCode() {
			return this.companyCode;
		}
		public void setCompanyCode(String companyCode) {
			this.companyCode = companyCode;
		}
		public String getCompanyName() {
			return this.companyName;
		}
		public void setCompanyName(String companyName) {
			this.companyName = companyName;
		}
		public Long getEntUicId() {
			return this.entUicId;
		}
		public void setEntUicId(Long entUicId) {
			this.entUicId = entUicId;
		}
		public Long getLogisticsCompanyId() {
			return this.logisticsCompanyId;
		}
		public void setLogisticsCompanyId(Long logisticsCompanyId) {
			this.logisticsCompanyId = logisticsCompanyId;
		}
		public String getMailNo() {
			return this.mailNo;
		}
		public void setMailNo(String mailNo) {
			this.mailNo = mailNo;
		}
		public String getOpenid() {
			return this.openid;
		}
		public void setOpenid(String openid) {
			this.openid = openid;
		}
		public String getRoleCode() {
			return this.roleCode;
		}
		public void setRoleCode(String roleCode) {
			this.roleCode = roleCode;
		}
		public Long getStoreId() {
			return this.storeId;
		}
		public void setStoreId(Long storeId) {
			this.storeId = storeId;
		}
		public Boolean getStoreSelfDelivery() {
			return this.storeSelfDelivery;
		}
		public void setStoreSelfDelivery(Boolean storeSelfDelivery) {
			this.storeSelfDelivery = storeSelfDelivery;
		}

}


}