package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.OmniorderDtdConsignResponse;

/**
 * TOP API: taobao.omniorder.dtd.consign request
 * 
 * @author top auto create
 * @since 1.0, 2024.05.05
 */
public class OmniorderDtdConsignRequest extends BaseTaobaoRequest<OmniorderDtdConsignResponse> {
	
	

	/** 
	* 淘宝订单主订单号
	 */
	private Long mainOrderId;

	/** 
	* 发货对应的商户中心门店ID
	 */
	private Long storeId;

	public void setMainOrderId(Long mainOrderId) {
		this.mainOrderId = mainOrderId;
	}

	public Long getMainOrderId() {
		return this.mainOrderId;
	}

	public void setStoreId(Long storeId) {
		this.storeId = storeId;
	}

	public Long getStoreId() {
		return this.storeId;
	}

	public String getApiMethodName() {
		return "taobao.omniorder.dtd.consign";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("main_order_id", this.mainOrderId);
		txtParams.put("store_id", this.storeId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<OmniorderDtdConsignResponse> getResponseClass() {
		return OmniorderDtdConsignResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(mainOrderId, "mainOrderId");
	}
	

}