package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.OmniorderDtdConsumeResponse;

/**
 * TOP API: taobao.omniorder.dtd.consume request
 * 
 * @author top auto create
 * @since 1.0, 2024.05.05
 */
public class OmniorderDtdConsumeRequest extends BaseTaobaoRequest<OmniorderDtdConsumeResponse> {
	
	

	/** 
	* 核销信息
	 */
	private String paramDoor2doorConsumeRequest;

	public void setParamDoor2doorConsumeRequest(String paramDoor2doorConsumeRequest) {
		this.paramDoor2doorConsumeRequest = paramDoor2doorConsumeRequest;
	}

	public void setParamDoor2doorConsumeRequest(Door2doorConsumeRequest paramDoor2doorConsumeRequest) {
		this.paramDoor2doorConsumeRequest = new JSONWriter(false,true).write(paramDoor2doorConsumeRequest);
	}

	public String getParamDoor2doorConsumeRequest() {
		return this.paramDoor2doorConsumeRequest;
	}

	public String getApiMethodName() {
		return "taobao.omniorder.dtd.consume";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param_door2door_consume_request", this.paramDoor2doorConsumeRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<OmniorderDtdConsumeResponse> getResponseClass() {
		return OmniorderDtdConsumeResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 核销信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Door2doorConsumeRequest extends TaobaoObject {

	private static final long serialVersionUID = 5389468153117219799L;

	/**
		 * 核销码
		 */
		@ApiField("code")
		private String code;
		/**
		 * 淘宝主订单ID
		 */
		@ApiField("main_order_id")
		private Long mainOrderId;
		/**
		 * 操作人
		 */
		@ApiField("operator")
		private String operator;
	

	public String getCode() {
			return this.code;
		}
		public void setCode(String code) {
			this.code = code;
		}
		public Long getMainOrderId() {
			return this.mainOrderId;
		}
		public void setMainOrderId(Long mainOrderId) {
			this.mainOrderId = mainOrderId;
		}
		public String getOperator() {
			return this.operator;
		}
		public void setOperator(String operator) {
			this.operator = operator;
		}

}


}