package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.OmniorderDtdResendResponse;

/**
 * TOP API: taobao.omniorder.dtd.resend request
 * 
 * @author top auto create
 * @since 1.0, 2024.05.05
 */
public class OmniorderDtdResendRequest extends BaseTaobaoRequest<OmniorderDtdResendResponse> {
	
	

	/** 
	* 淘宝主订单ID
	 */
	private Long mainOrderId;

	public void setMainOrderId(Long mainOrderId) {
		this.mainOrderId = mainOrderId;
	}

	public Long getMainOrderId() {
		return this.mainOrderId;
	}

	public String getApiMethodName() {
		return "taobao.omniorder.dtd.resend";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("main_order_id", this.mainOrderId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<OmniorderDtdResendResponse> getResponseClass() {
		return OmniorderDtdResendResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(mainOrderId, "mainOrderId");
	}
	

}