package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.OmniorderItemTagOperateResponse;

/**
 * TOP API: taobao.omniorder.item.tag.operate request
 * 
 * @author top auto create
 * @since 1.0, 2024.05.05
 */
public class OmniorderItemTagOperateRequest extends BaseTaobaoRequest<OmniorderItemTagOperateResponse> {
	
	

	/** 
	* 商品ID
	 */
	private Long itemId;

	/** 
	* 分单&接单设置
	 */
	private String omniSetting;

	/** 
	* 操作状态， 填 1 代表打标，填 -1 代表去标
	 */
	private Long status;

	/** 
	* 商品标,storeDeliver代表门店发货, AllocateByFront代表前置拆单, storeCollect代表门店自提
	 */
	private String types;

	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}

	public Long getItemId() {
		return this.itemId;
	}

	public void setOmniSetting(String omniSetting) {
		this.omniSetting = omniSetting;
	}

	public void setOmniSetting(OmniSettingDto omniSetting) {
		this.omniSetting = new JSONWriter(false,true).write(omniSetting);
	}

	public String getOmniSetting() {
		return this.omniSetting;
	}

	public void setStatus(Long status) {
		this.status = status;
	}

	public Long getStatus() {
		return this.status;
	}

	public void setTypes(String types) {
		this.types = types;
	}

	public String getTypes() {
		return this.types;
	}

	public String getApiMethodName() {
		return "taobao.omniorder.item.tag.operate";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("item_id", this.itemId);
		txtParams.put("omni_setting", this.omniSetting);
		txtParams.put("status", this.status);
		txtParams.put("types", this.types);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<OmniorderItemTagOperateResponse> getResponseClass() {
		return OmniorderItemTagOperateResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(itemId, "itemId");
		RequestCheckUtils.checkNotEmpty(status, "status");
		RequestCheckUtils.checkNotEmpty(types, "types");
		RequestCheckUtils.checkMaxListSize(types, 20, "types");
	}
	
	/**
 * 分单&接单设置
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class OmniSettingDto extends TaobaoObject {

	private static final long serialVersionUID = 8725172736848759343L;

	/**
		 * 接单系统，填 0 代表店掌柜，填 1 代表 POS
		 */
		@ApiField("accepted_system")
		private Long acceptedSystem;
		/**
		 * 分单系统，填 astrolabe 代表阿里分单，填 RDS的 appkey 代表自行分单
		 */
		@ApiField("allocated_system")
		private String allocatedSystem;
	

	public Long getAcceptedSystem() {
			return this.acceptedSystem;
		}
		public void setAcceptedSystem(Long acceptedSystem) {
			this.acceptedSystem = acceptedSystem;
		}
		public String getAllocatedSystem() {
			return this.allocatedSystem;
		}
		public void setAllocatedSystem(String allocatedSystem) {
			this.allocatedSystem = allocatedSystem;
		}

}


}