package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.OmniorderStoreCollectconfigGetResponse;

/**
 * TOP API: taobao.omniorder.store.collectconfig.get request
 * 
 * @author top auto create
 * @since 1.0, 2021.11.25
 */
public class OmniorderStoreCollectconfigGetRequest extends BaseTaobaoRequest<OmniorderStoreCollectconfigGetResponse> {
	
	

	/** 
	* 是否是活动期
	 */
	private Boolean activity;

	/** 
	* 门店ID
	 */
	private Long storeId;

	public void setActivity(Boolean activity) {
		this.activity = activity;
	}

	public Boolean getActivity() {
		return this.activity;
	}

	public void setStoreId(Long storeId) {
		this.storeId = storeId;
	}

	public Long getStoreId() {
		return this.storeId;
	}

	public String getApiMethodName() {
		return "taobao.omniorder.store.collectconfig.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("activity", this.activity);
		txtParams.put("store_id", this.storeId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<OmniorderStoreCollectconfigGetResponse> getResponseClass() {
		return OmniorderStoreCollectconfigGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(storeId, "storeId");
	}
	

}