package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.TaobaoObject;
import java.util.Date;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.OmniorderStoreCollectconfigUpdateResponse;

/**
 * TOP API: taobao.omniorder.store.collectconfig.update request
 * 
 * @author top auto create
 * @since 1.0, 2022.09.19
 */
public class OmniorderStoreCollectconfigUpdateRequest extends BaseTaobaoRequest<OmniorderStoreCollectconfigUpdateResponse> {
	
	

	/** 
	* 门店自提配置
	 */
	private String storeCollectConfig;

	/** 
	* 门店ID
	 */
	private Long storeId;

	public void setStoreCollectConfig(String storeCollectConfig) {
		this.storeCollectConfig = storeCollectConfig;
	}

	public void setStoreCollectConfig(StoreCollectConfig storeCollectConfig) {
		this.storeCollectConfig = new JSONWriter(false,true).write(storeCollectConfig);
	}

	public String getStoreCollectConfig() {
		return this.storeCollectConfig;
	}

	public void setStoreId(Long storeId) {
		this.storeId = storeId;
	}

	public Long getStoreId() {
		return this.storeId;
	}

	public String getApiMethodName() {
		return "taobao.omniorder.store.collectconfig.update";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("store_collect_config", this.storeCollectConfig);
		txtParams.put("store_id", this.storeId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<OmniorderStoreCollectconfigUpdateResponse> getResponseClass() {
		return OmniorderStoreCollectconfigUpdateResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(storeId, "storeId");
	}
	
	/**
 * 门店自提配置
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class StoreCollectConfig extends TaobaoObject {

	private static final long serialVersionUID = 6518275235783844745L;

	/**
		 * 是否是活动期
		 */
		@ApiField("activity")
		private Boolean activity;
		/**
		 * 活动开始时间
		 */
		@ApiField("activity_end_time")
		private Date activityEndTime;
		/**
		 * 活动结束时间
		 */
		@ApiField("activity_start_time")
		private Date activityStartTime;
		/**
		 * 每日接单阈值
		 */
		@ApiField("collect_threshold")
		private Long collectThreshold;
		/**
		 * 接单时间段，格式为 "09:00-12:00", "" 表示一直开启
		 */
		@ApiField("working_time")
		private String workingTime;
	

	public Boolean getActivity() {
			return this.activity;
		}
		public void setActivity(Boolean activity) {
			this.activity = activity;
		}
		public Date getActivityEndTime() {
			return this.activityEndTime;
		}
		public void setActivityEndTime(Date activityEndTime) {
			this.activityEndTime = activityEndTime;
		}
		public Date getActivityStartTime() {
			return this.activityStartTime;
		}
		public void setActivityStartTime(Date activityStartTime) {
			this.activityStartTime = activityStartTime;
		}
		public Long getCollectThreshold() {
			return this.collectThreshold;
		}
		public void setCollectThreshold(Long collectThreshold) {
			this.collectThreshold = collectThreshold;
		}
		public String getWorkingTime() {
			return this.workingTime;
		}
		public void setWorkingTime(String workingTime) {
			this.workingTime = workingTime;
		}

}


}