package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.json.JSONValidatingReader;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.OmniorderStoreConsignedResponse;

/**
 * TOP API: taobao.omniorder.store.consigned request
 * 
 * @author top auto create
 * @since 1.0, 2024.05.05
 */
public class OmniorderStoreConsignedRequest extends BaseTaobaoRequest<OmniorderStoreConsignedResponse> {
	
	

	/** 
	* 家装物流-安装收货人信息,如果为空,则取默认收货人信息
	 */
	private String insReceiverTo;

	/** 
	* 家装物流-安装公司信息,需要安装时,才填写
	 */
	private String insTpDto;

	/** 
	* 家装物流-家装收货人信息,如果为空,则取默认收货信息
	 */
	private String jzReceiverTo;

	/** 
	* 家装物流-发货参数
	 */
	private String jzTopArgs;

	/** 
	* 家装物流-物流公司信息
	 */
	private String lgTpDto;

	/** 
	* ISV系统上报时间
	 */
	private Long reportTimestamp;

	/** 
	* 卖家联系人地址库ID，可以通过taobao.logistics.address.search接口查询到地址库ID。如果为空，取的卖家的默认取货地址
	 */
	private Long senderId;

	/** 
	* 子订单列表
	 */
	private String subOrderList;

	/** 
	* 淘宝交易主订单ID
	 */
	private Long tid;

	/** 
	* 跟踪Id
	 */
	private String traceId;

	public void setInsReceiverTo(String insReceiverTo) {
		this.insReceiverTo = insReceiverTo;
	}

	public void setInsReceiverTo(JzReceiverDto insReceiverTo) {
		this.insReceiverTo = new JSONWriter(false,true).write(insReceiverTo);
	}

	public String getInsReceiverTo() {
		return this.insReceiverTo;
	}

	public void setInsTpDto(String insTpDto) {
		this.insTpDto = insTpDto;
	}

	public void setInsTpDto(TpDto insTpDto) {
		this.insTpDto = new JSONWriter(false,true).write(insTpDto);
	}

	public String getInsTpDto() {
		return this.insTpDto;
	}

	public void setJzReceiverTo(String jzReceiverTo) {
		this.jzReceiverTo = jzReceiverTo;
	}

	public void setJzReceiverTo(JzReceiverDto jzReceiverTo) {
		this.jzReceiverTo = new JSONWriter(false,true).write(jzReceiverTo);
	}

	public String getJzReceiverTo() {
		return this.jzReceiverTo;
	}

	public void setJzTopArgs(String jzTopArgs) {
		this.jzTopArgs = jzTopArgs;
	}

	public void setJzTopArgs(JzTopArgsDto jzTopArgs) {
		this.jzTopArgs = new JSONWriter(false,true).write(jzTopArgs);
	}

	public String getJzTopArgs() {
		return this.jzTopArgs;
	}

	public void setLgTpDto(String lgTpDto) {
		this.lgTpDto = lgTpDto;
	}

	public void setLgTpDto(TpDto lgTpDto) {
		this.lgTpDto = new JSONWriter(false,true).write(lgTpDto);
	}

	public String getLgTpDto() {
		return this.lgTpDto;
	}

	public void setReportTimestamp(Long reportTimestamp) {
		this.reportTimestamp = reportTimestamp;
	}

	public Long getReportTimestamp() {
		return this.reportTimestamp;
	}

	public void setSenderId(Long senderId) {
		this.senderId = senderId;
	}

	public Long getSenderId() {
		return this.senderId;
	}

	public void setSubOrderList(String subOrderList) {
		this.subOrderList = subOrderList;
	}

	public void setSubOrderList(List<StoreConsignedResult> subOrderList) {
		this.subOrderList = new JSONWriter(false,true).write(subOrderList);
	}

	public String getSubOrderList() {
		return this.subOrderList;
	}

	public void setTid(Long tid) {
		this.tid = tid;
	}

	public Long getTid() {
		return this.tid;
	}

	public void setTraceId(String traceId) {
		this.traceId = traceId;
	}

	public String getTraceId() {
		return this.traceId;
	}

	public String getApiMethodName() {
		return "taobao.omniorder.store.consigned";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("ins_receiver_to", this.insReceiverTo);
		txtParams.put("ins_tp_dto", this.insTpDto);
		txtParams.put("jz_receiver_to", this.jzReceiverTo);
		txtParams.put("jz_top_args", this.jzTopArgs);
		txtParams.put("lg_tp_dto", this.lgTpDto);
		txtParams.put("report_timestamp", this.reportTimestamp);
		txtParams.put("sender_id", this.senderId);
		txtParams.put("sub_order_list", this.subOrderList);
		txtParams.put("tid", this.tid);
		txtParams.put("trace_id", this.traceId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<OmniorderStoreConsignedResponse> getResponseClass() {
		return OmniorderStoreConsignedResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(reportTimestamp, "reportTimestamp");
		RequestCheckUtils.checkObjectMaxListSize(subOrderList, 20, "subOrderList");
		RequestCheckUtils.checkNotEmpty(tid, "tid");
	}
	
	/**
 * 家装物流-安装收货人信息,如果为空,则取默认收货人信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class JzReceiverDto extends TaobaoObject {

	private static final long serialVersionUID = 5885123616583327576L;

	/**
		 * 详细地址
		 */
		@ApiField("address")
		private String address;
		/**
		 * 市
		 */
		@ApiField("city")
		private String city;
		/**
		 * 收货人名称
		 */
		@ApiField("contact_name")
		private String contactName;
		/**
		 * 国家
		 */
		@ApiField("country")
		private String country;
		/**
		 * 区
		 */
		@ApiField("district")
		private String district;
		/**
		 * 手机号
		 */
		@ApiField("mobile_phone")
		private String mobilePhone;
		/**
		 * 省
		 */
		@ApiField("province")
		private String province;
		/**
		 * 街道
		 */
		@ApiField("street")
		private String street;
		/**
		 * 座机号
		 */
		@ApiField("tele_phone")
		private String telePhone;
		/**
		 * 邮编
		 */
		@ApiField("zip_code")
		private String zipCode;
	

	public String getAddress() {
			return this.address;
		}
		public void setAddress(String address) {
			this.address = address;
		}
		public String getCity() {
			return this.city;
		}
		public void setCity(String city) {
			this.city = city;
		}
		public String getContactName() {
			return this.contactName;
		}
		public void setContactName(String contactName) {
			this.contactName = contactName;
		}
		public String getCountry() {
			return this.country;
		}
		public void setCountry(String country) {
			this.country = country;
		}
		public String getDistrict() {
			return this.district;
		}
		public void setDistrict(String district) {
			this.district = district;
		}
		public String getMobilePhone() {
			return this.mobilePhone;
		}
		public void setMobilePhone(String mobilePhone) {
			this.mobilePhone = mobilePhone;
		}
		public String getProvince() {
			return this.province;
		}
		public void setProvince(String province) {
			this.province = province;
		}
		public String getStreet() {
			return this.street;
		}
		public void setStreet(String street) {
			this.street = street;
		}
		public String getTelePhone() {
			return this.telePhone;
		}
		public void setTelePhone(String telePhone) {
			this.telePhone = telePhone;
		}
		public String getZipCode() {
			return this.zipCode;
		}
		public void setZipCode(String zipCode) {
			this.zipCode = zipCode;
		}

}

	/**
 * 子订单列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class StoreConsignedResult extends TaobaoObject {

	private static final long serialVersionUID = 3531356221657497287L;

	/**
		 * 扩展字段
		 */
		@ApiField("attributes")
		private String attributes;
		/**
		 * 0表示无系统异常
		 */
		@ApiField("code")
		private String code;
		/**
		 * 物流公司名称
		 */
		@ApiField("logistic_company")
		private String logisticCompany;
		/**
		 * 物流公司code，如果id和code都填入，以code为准。点点送：DISTRIBUTOR_12006531；门店自送：DISTRIBUTOR_12709653；如果是菜鸟配送，code和company可以为空
		 */
		@ApiField("logistic_company_code")
		private String logisticCompanyCode;
		/**
		 * 物流公司id
		 */
		@ApiField("logistic_id")
		private String logisticId;
		/**
		 * 物流单号
		 */
		@ApiField("logistic_no")
		private String logisticNo;
		/**
		 * 异常描述
		 */
		@ApiField("message")
		private String message;
		/**
		 * 操作者
		 */
		@ApiField("operator")
		private String operator;
		/**
		 * 速店通packageId
		 */
		@ApiField("package_id")
		private Long packageId;
		/**
		 * 店铺Id, 可能是门店或者电商仓
		 */
		@ApiField("store_id")
		private String storeId;
		/**
		 * 店铺名称
		 */
		@ApiField("store_name")
		private String storeName;
		/**
		 * 店铺类型, 门店(Store)或者电商仓(Warehouse)
		 */
		@ApiField("store_type")
		private String storeType;
		/**
		 * 子订单Id
		 */
		@ApiField("sub_oid")
		private Long subOid;
		/**
		 * 主订单Id
		 */
		@ApiField("tid")
		private Long tid;
	

	public String getAttributes() {
			return this.attributes;
		}
		public void setAttributes(String attributes) {
			this.attributes = attributes;
		}
		public void setAttributesString(String attributes) {
			this.attributes = attributes;
		}
		
		public String getCode() {
			return this.code;
		}
		public void setCode(String code) {
			this.code = code;
		}
		public String getLogisticCompany() {
			return this.logisticCompany;
		}
		public void setLogisticCompany(String logisticCompany) {
			this.logisticCompany = logisticCompany;
		}
		public String getLogisticCompanyCode() {
			return this.logisticCompanyCode;
		}
		public void setLogisticCompanyCode(String logisticCompanyCode) {
			this.logisticCompanyCode = logisticCompanyCode;
		}
		public String getLogisticId() {
			return this.logisticId;
		}
		public void setLogisticId(String logisticId) {
			this.logisticId = logisticId;
		}
		public String getLogisticNo() {
			return this.logisticNo;
		}
		public void setLogisticNo(String logisticNo) {
			this.logisticNo = logisticNo;
		}
		public String getMessage() {
			return this.message;
		}
		public void setMessage(String message) {
			this.message = message;
		}
		public String getOperator() {
			return this.operator;
		}
		public void setOperator(String operator) {
			this.operator = operator;
		}
		public Long getPackageId() {
			return this.packageId;
		}
		public void setPackageId(Long packageId) {
			this.packageId = packageId;
		}
		public String getStoreId() {
			return this.storeId;
		}
		public void setStoreId(String storeId) {
			this.storeId = storeId;
		}
		public String getStoreName() {
			return this.storeName;
		}
		public void setStoreName(String storeName) {
			this.storeName = storeName;
		}
		public String getStoreType() {
			return this.storeType;
		}
		public void setStoreType(String storeType) {
			this.storeType = storeType;
		}
		public Long getSubOid() {
			return this.subOid;
		}
		public void setSubOid(Long subOid) {
			this.subOid = subOid;
		}
		public Long getTid() {
			return this.tid;
		}
		public void setTid(Long tid) {
			this.tid = tid;
		}

}

	/**
 * 家装物流-发货参数
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class JzTopArgsDto extends TaobaoObject {

	private static final long serialVersionUID = 3741232852973554741L;

	/**
		 * 运单号,用快递或商家自有发货时,必填
		 */
		@ApiField("mail_no")
		private String mailNo;
		/**
		 * 包裹数量
		 */
		@ApiField("package_number")
		private String packageNumber;
		/**
		 * 包裹备注
		 */
		@ApiField("package_remark")
		private String packageRemark;
		/**
		 * 包裹体积
		 */
		@ApiField("package_volume")
		private String packageVolume;
		/**
		 * 包裹重量
		 */
		@ApiField("package_weight")
		private String packageWeight;
		/**
		 * 自有物流公司名称
		 */
		@ApiField("zy_company")
		private String zyCompany;
		/**
		 * 自有物流发货时间,时间不能早于当前时间
		 */
		@ApiField("zy_consign_time")
		private String zyConsignTime;
		/**
		 * 自有物流公司电话
		 */
		@ApiField("zy_phone_number")
		private String zyPhoneNumber;
	

	public String getMailNo() {
			return this.mailNo;
		}
		public void setMailNo(String mailNo) {
			this.mailNo = mailNo;
		}
		public String getPackageNumber() {
			return this.packageNumber;
		}
		public void setPackageNumber(String packageNumber) {
			this.packageNumber = packageNumber;
		}
		public String getPackageRemark() {
			return this.packageRemark;
		}
		public void setPackageRemark(String packageRemark) {
			this.packageRemark = packageRemark;
		}
		public String getPackageVolume() {
			return this.packageVolume;
		}
		public void setPackageVolume(String packageVolume) {
			this.packageVolume = packageVolume;
		}
		public String getPackageWeight() {
			return this.packageWeight;
		}
		public void setPackageWeight(String packageWeight) {
			this.packageWeight = packageWeight;
		}
		public String getZyCompany() {
			return this.zyCompany;
		}
		public void setZyCompany(String zyCompany) {
			this.zyCompany = zyCompany;
		}
		public String getZyConsignTime() {
			return this.zyConsignTime;
		}
		public void setZyConsignTime(String zyConsignTime) {
			this.zyConsignTime = zyConsignTime;
		}
		public String getZyPhoneNumber() {
			return this.zyPhoneNumber;
		}
		public void setZyPhoneNumber(String zyPhoneNumber) {
			this.zyPhoneNumber = zyPhoneNumber;
		}

}

	/**
 * 家装物流-安装公司信息,需要安装时,才填写
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TpDto extends TaobaoObject {

	private static final long serialVersionUID = 6746832524768855329L;

	/**
		 * 公司编码
		 */
		@ApiField("code")
		private String code;
		/**
		 * 公司名称
		 */
		@ApiField("name")
		private String name;
	

	public String getCode() {
			return this.code;
		}
		public void setCode(String code) {
			this.code = code;
		}
		public String getName() {
			return this.name;
		}
		public void setName(String name) {
			this.name = name;
		}

}


}