package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.OmniorderStoreDeliverconfigGetResponse;

/**
 * TOP API: taobao.omniorder.store.deliverconfig.get request
 * 
 * @author top auto create
 * @since 1.0, 2021.11.23
 */
public class OmniorderStoreDeliverconfigGetRequest extends BaseTaobaoRequest<OmniorderStoreDeliverconfigGetResponse> {
	
	

	/** 
	* 是否是活动期
	 */
	private Boolean activity;

	/** 
	* 门店ID
	 */
	private Long storeId;

	public void setActivity(Boolean activity) {
		this.activity = activity;
	}

	public Boolean getActivity() {
		return this.activity;
	}

	public void setStoreId(Long storeId) {
		this.storeId = storeId;
	}

	public Long getStoreId() {
		return this.storeId;
	}

	public String getApiMethodName() {
		return "taobao.omniorder.store.deliverconfig.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("activity", this.activity);
		txtParams.put("store_id", this.storeId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<OmniorderStoreDeliverconfigGetResponse> getResponseClass() {
		return OmniorderStoreDeliverconfigGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(storeId, "storeId");
	}
	

}