package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.TaobaoObject;
import java.util.Date;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.OmniorderStoreDeliverconfigUpdateResponse;

/**
 * TOP API: taobao.omniorder.store.deliverconfig.update request
 * 
 * @author top auto create
 * @since 1.0, 2022.09.19
 */
public class OmniorderStoreDeliverconfigUpdateRequest extends BaseTaobaoRequest<OmniorderStoreDeliverconfigUpdateResponse> {
	
	

	/** 
	* 卖家发货配置
	 */
	private String storeDeliverConfig;

	/** 
	* 门店ID
	 */
	private Long storeId;

	public void setStoreDeliverConfig(String storeDeliverConfig) {
		this.storeDeliverConfig = storeDeliverConfig;
	}

	public void setStoreDeliverConfig(StoreDeliverConfig storeDeliverConfig) {
		this.storeDeliverConfig = new JSONWriter(false,true).write(storeDeliverConfig);
	}

	public String getStoreDeliverConfig() {
		return this.storeDeliverConfig;
	}

	public void setStoreId(Long storeId) {
		this.storeId = storeId;
	}

	public Long getStoreId() {
		return this.storeId;
	}

	public String getApiMethodName() {
		return "taobao.omniorder.store.deliverconfig.update";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("store_deliver_config", this.storeDeliverConfig);
		txtParams.put("store_id", this.storeId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<OmniorderStoreDeliverconfigUpdateResponse> getResponseClass() {
		return OmniorderStoreDeliverconfigUpdateResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(storeId, "storeId");
	}
	
	/**
 * 卖家发货配置
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class StoreDeliverConfig extends TaobaoObject {

	private static final long serialVersionUID = 5218897966915578695L;

	/**
		 * 是否是活动期
		 */
		@ApiField("activity")
		private Boolean activity;
		/**
		 * 活动结束时间
		 */
		@ApiField("activity_end_time")
		private Date activityEndTime;
		/**
		 * 活动开始时间
		 */
		@ApiField("activity_start_time")
		private Date activityStartTime;
		/**
		 * 每日接单阈值
		 */
		@ApiField("deliver_threshold")
		private Long deliverThreshold;
		/**
		 * 派单时间，格式为：[{"startTime":"08:40","endTime":"12:20"},{"startTime":"18:00","endTime":"22:00"}]
		 */
		@ApiField("dispatch_time_range")
		private String dispatchTimeRange;
		/**
		 * 优先级，取值范围为0-10,0最大，10最小
		 */
		@ApiField("priority")
		private Long priority;
		/**
		 * 接单时间段，格式为 "09:00-12:00", "" 表示一直开启
		 */
		@ApiField("working_time")
		private String workingTime;
	

	public Boolean getActivity() {
			return this.activity;
		}
		public void setActivity(Boolean activity) {
			this.activity = activity;
		}
		public Date getActivityEndTime() {
			return this.activityEndTime;
		}
		public void setActivityEndTime(Date activityEndTime) {
			this.activityEndTime = activityEndTime;
		}
		public Date getActivityStartTime() {
			return this.activityStartTime;
		}
		public void setActivityStartTime(Date activityStartTime) {
			this.activityStartTime = activityStartTime;
		}
		public Long getDeliverThreshold() {
			return this.deliverThreshold;
		}
		public void setDeliverThreshold(Long deliverThreshold) {
			this.deliverThreshold = deliverThreshold;
		}
		public String getDispatchTimeRange() {
			return this.dispatchTimeRange;
		}
		public void setDispatchTimeRange(String dispatchTimeRange) {
			this.dispatchTimeRange = dispatchTimeRange;
		}
		public Long getPriority() {
			return this.priority;
		}
		public void setPriority(Long priority) {
			this.priority = priority;
		}
		public String getWorkingTime() {
			return this.workingTime;
		}
		public void setWorkingTime(String workingTime) {
			this.workingTime = workingTime;
		}

}


}