package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.OmniorderStoreReallocateResponse;

/**
 * TOP API: taobao.omniorder.store.reallocate request
 * 
 * @author top auto create
 * @since 1.0, 2024.05.05
 */
public class OmniorderStoreReallocateRequest extends BaseTaobaoRequest<OmniorderStoreReallocateResponse> {
	
	

	/** 
	* 主订单号
	 */
	private Long mainOrderId;

	/** 
	* 门店Id
	 */
	private Long storeId;

	/** 
	* 子订单号
	 */
	private String subOrderIds;

	/** 
	* 电商仓code
	 */
	private String warehouseCode;

	public void setMainOrderId(Long mainOrderId) {
		this.mainOrderId = mainOrderId;
	}

	public Long getMainOrderId() {
		return this.mainOrderId;
	}

	public void setStoreId(Long storeId) {
		this.storeId = storeId;
	}

	public Long getStoreId() {
		return this.storeId;
	}

	public void setSubOrderIds(String subOrderIds) {
		this.subOrderIds = subOrderIds;
	}

	public String getSubOrderIds() {
		return this.subOrderIds;
	}

	public void setWarehouseCode(String warehouseCode) {
		this.warehouseCode = warehouseCode;
	}

	public String getWarehouseCode() {
		return this.warehouseCode;
	}

	public String getApiMethodName() {
		return "taobao.omniorder.store.reallocate";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("main_order_id", this.mainOrderId);
		txtParams.put("store_id", this.storeId);
		txtParams.put("sub_order_ids", this.subOrderIds);
		txtParams.put("warehouse_code", this.warehouseCode);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<OmniorderStoreReallocateResponse> getResponseClass() {
		return OmniorderStoreReallocateResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(mainOrderId, "mainOrderId");
		RequestCheckUtils.checkNotEmpty(subOrderIds, "subOrderIds");
		RequestCheckUtils.checkMaxListSize(subOrderIds, 100, "subOrderIds");
	}
	

}