package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.OmniorderStoreSwitchstatusGetResponse;

/**
 * TOP API: taobao.omniorder.store.switchstatus.get request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class OmniorderStoreSwitchstatusGetRequest extends BaseTaobaoRequest<OmniorderStoreSwitchstatusGetResponse> {
	
	

	/** 
	* 卖家ID
	 */
	private Long sellerId;

	/** 
	* 门店ID
	 */
	private Long storeId;

	public void setSellerId(Long sellerId) {
		this.sellerId = sellerId;
	}

	public Long getSellerId() {
		return this.sellerId;
	}

	public void setStoreId(Long storeId) {
		this.storeId = storeId;
	}

	public Long getStoreId() {
		return this.storeId;
	}

	public String getApiMethodName() {
		return "taobao.omniorder.store.switchstatus.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("seller_id", this.sellerId);
		txtParams.put("store_id", this.storeId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<OmniorderStoreSwitchstatusGetResponse> getResponseClass() {
		return OmniorderStoreSwitchstatusGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(sellerId, "sellerId");
		RequestCheckUtils.checkNotEmpty(storeId, "storeId");
	}
	

}