package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.OmniorderStorecollectConsumeResponse;

/**
 * TOP API: taobao.omniorder.storecollect.consume request
 * 
 * @author top auto create
 * @since 1.0, 2024.05.05
 */
public class OmniorderStorecollectConsumeRequest extends BaseTaobaoRequest<OmniorderStorecollectConsumeResponse> {
	
	

	/** 
	* 核销码
	 */
	private String code;

	/** 
	* 淘宝主订单ID
	 */
	private Long mainOrderId;

	/** 
	* 核销操作人信息
	 */
	private String operator;

	public void setCode(String code) {
		this.code = code;
	}

	public String getCode() {
		return this.code;
	}

	public void setMainOrderId(Long mainOrderId) {
		this.mainOrderId = mainOrderId;
	}

	public Long getMainOrderId() {
		return this.mainOrderId;
	}

	public void setOperator(String operator) {
		this.operator = operator;
	}

	public String getOperator() {
		return this.operator;
	}

	public String getApiMethodName() {
		return "taobao.omniorder.storecollect.consume";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("code", this.code);
		txtParams.put("main_order_id", this.mainOrderId);
		txtParams.put("operator", this.operator);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<OmniorderStorecollectConsumeResponse> getResponseClass() {
		return OmniorderStorecollectConsumeResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(code, "code");
		RequestCheckUtils.checkNotEmpty(mainOrderId, "mainOrderId");
	}
	

}