package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.OmniorderStorecollectQueryResponse;

/**
 * TOP API: taobao.omniorder.storecollect.query request
 * 
 * @author top auto create
 * @since 1.0, 2024.05.05
 */
public class OmniorderStorecollectQueryRequest extends BaseTaobaoRequest<OmniorderStorecollectQueryResponse> {
	
	

	/** 
	* 核销码
	 */
	private String code;

	public void setCode(String code) {
		this.code = code;
	}

	public String getCode() {
		return this.code;
	}

	public String getApiMethodName() {
		return "taobao.omniorder.storecollect.query";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("code", this.code);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<OmniorderStorecollectQueryResponse> getResponseClass() {
		return OmniorderStorecollectQueryResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(code, "code");
	}
	

}