package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.RefundStatusGetResponse;

/**
 * TOP API: taobao.refund.status.get request
 * 
 * @author top auto create
 * @since 1.0, 2022.08.26
 */
public class RefundStatusGetRequest extends BaseTaobaoRequest<RefundStatusGetResponse> {
	
	

	/** 
	* 入参对象
	 */
	private String queryParam;

	public void setQueryParam(String queryParam) {
		this.queryParam = queryParam;
	}

	public void setQueryParam(RefundQueryByOrderIdRequest queryParam) {
		this.queryParam = new JSONWriter(false,true).write(queryParam);
	}

	public String getQueryParam() {
		return this.queryParam;
	}

	public String getApiMethodName() {
		return "taobao.refund.status.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("query_param", this.queryParam);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<RefundStatusGetResponse> getResponseClass() {
		return RefundStatusGetResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 入参对象
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class RefundQueryByOrderIdRequest extends TaobaoObject {

	private static final long serialVersionUID = 7343291821631722788L;

	/**
		 * 订单号
		 */
		@ApiField("biz_order_id")
		private Long bizOrderId;
	

	public Long getBizOrderId() {
			return this.bizOrderId;
		}
		public void setBizOrderId(Long bizOrderId) {
			this.bizOrderId = bizOrderId;
		}

}


}