package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.RpReturngoodsAgreeResponse;

/**
 * TOP API: taobao.rp.returngoods.agree request
 * 
 * @author top auto create
 * @since 1.0, 2025.01.09
 */
public class RpReturngoodsAgreeRequest extends BaseTaobaoRequest<RpReturngoodsAgreeResponse> {
	
	

	/** 
	* 卖家提供的退货地址，淘宝退款为必填项。
	 */
	private String address;

	/** 
	* 卖家手机，淘宝退款为必填项。
	 */
	private String mobile;

	/** 
	* 卖家姓名，淘宝退款为必填项。
	 */
	private String name;

	/** 
	* 卖家提供的退货地址的邮编，淘宝退款为必填项。
	 */
	private String post;

	/** 
	* 邮费承担方，买家承担值为1，卖家承担值为0
	 */
	private Long postFeeBearRole;

	/** 
	* 退款编号
	 */
	private Long refundId;

	/** 
	* 售中：onsale，售后：aftersale，天猫退款为必填项。
	 */
	private String refundPhase;

	/** 
	* 退款版本号，天猫退款为必填项。
	 */
	private Long refundVersion;

	/** 
	* 卖家退货留言，天猫退款为必填项。
	 */
	private String remark;

	/** 
	* 卖家收货地址编号，天猫淘宝退款都为必填项。
	 */
	private Long sellerAddressId;

	/** 
	* 卖家座机，淘宝退款为必填项。
	 */
	private String tel;

	/** 
	* 是否虚拟退货，可选项
	 */
	private Boolean virtualReturnGoods;

	public void setAddress(String address) {
		this.address = address;
	}

	public String getAddress() {
		return this.address;
	}

	public void setMobile(String mobile) {
		this.mobile = mobile;
	}

	public String getMobile() {
		return this.mobile;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getName() {
		return this.name;
	}

	public void setPost(String post) {
		this.post = post;
	}

	public String getPost() {
		return this.post;
	}

	public void setPostFeeBearRole(Long postFeeBearRole) {
		this.postFeeBearRole = postFeeBearRole;
	}

	public Long getPostFeeBearRole() {
		return this.postFeeBearRole;
	}

	public void setRefundId(Long refundId) {
		this.refundId = refundId;
	}

	public Long getRefundId() {
		return this.refundId;
	}

	public void setRefundPhase(String refundPhase) {
		this.refundPhase = refundPhase;
	}

	public String getRefundPhase() {
		return this.refundPhase;
	}

	public void setRefundVersion(Long refundVersion) {
		this.refundVersion = refundVersion;
	}

	public Long getRefundVersion() {
		return this.refundVersion;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public String getRemark() {
		return this.remark;
	}

	public void setSellerAddressId(Long sellerAddressId) {
		this.sellerAddressId = sellerAddressId;
	}

	public Long getSellerAddressId() {
		return this.sellerAddressId;
	}

	public void setTel(String tel) {
		this.tel = tel;
	}

	public String getTel() {
		return this.tel;
	}

	public void setVirtualReturnGoods(Boolean virtualReturnGoods) {
		this.virtualReturnGoods = virtualReturnGoods;
	}

	public Boolean getVirtualReturnGoods() {
		return this.virtualReturnGoods;
	}

	public String getApiMethodName() {
		return "taobao.rp.returngoods.agree";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("address", this.address);
		txtParams.put("mobile", this.mobile);
		txtParams.put("name", this.name);
		txtParams.put("post", this.post);
		txtParams.put("post_fee_bear_role", this.postFeeBearRole);
		txtParams.put("refund_id", this.refundId);
		txtParams.put("refund_phase", this.refundPhase);
		txtParams.put("refund_version", this.refundVersion);
		txtParams.put("remark", this.remark);
		txtParams.put("seller_address_id", this.sellerAddressId);
		txtParams.put("tel", this.tel);
		txtParams.put("virtual_return_goods", this.virtualReturnGoods);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<RpReturngoodsAgreeResponse> getResponseClass() {
		return RpReturngoodsAgreeResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(refundId, "refundId");
	}
	

}