package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.ShopCoverageManageResponse;

/**
 * TOP API: taobao.shop.coverage.manage request
 * 
 * @author top auto create
 * @since 1.0, 2024.02.23
 */
public class ShopCoverageManageRequest extends BaseTaobaoRequest<ShopCoverageManageResponse> {
	
	

	/** 
	* 覆盖的地址列表。如覆盖整个省则传入省份即可；如只覆盖某个区需要按“省~市~区”格式传入。
	 */
	private String regions;

	/** 
	* 门店code
	 */
	private String shopCode;

	public void setRegions(String regions) {
		this.regions = regions;
	}

	public String getRegions() {
		return this.regions;
	}

	public void setShopCode(String shopCode) {
		this.shopCode = shopCode;
	}

	public String getShopCode() {
		return this.shopCode;
	}

	public String getApiMethodName() {
		return "taobao.shop.coverage.manage";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("regions", this.regions);
		txtParams.put("shop_code", this.shopCode);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<ShopCoverageManageResponse> getResponseClass() {
		return ShopCoverageManageResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(regions, "regions");
		RequestCheckUtils.checkNotEmpty(shopCode, "shopCode");
	}
	

}