package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.ShopCoverageQueryResponse;

/**
 * TOP API: taobao.shop.coverage.query request
 * 
 * @author top auto create
 * @since 1.0, 2024.02.23
 */
public class ShopCoverageQueryRequest extends BaseTaobaoRequest<ShopCoverageQueryResponse> {
	
	

	/** 
	* 门店code
	 */
	private String shopCode;

	public void setShopCode(String shopCode) {
		this.shopCode = shopCode;
	}

	public String getShopCode() {
		return this.shopCode;
	}

	public String getApiMethodName() {
		return "taobao.shop.coverage.query";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("shop_code", this.shopCode);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<ShopCoverageQueryResponse> getResponseClass() {
		return ShopCoverageQueryResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(shopCode, "shopCode");
	}
	

}