package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.json.JSONValidatingReader;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.SkuUpdateListingTmallResponse;

/**
 * TOP API: taobao.sku.update.listing.tmall request
 * 
 * @author top auto create
 * @since 1.0, 2024.03.13
 */
public class SkuUpdateListingTmallRequest extends BaseTaobaoRequest<SkuUpdateListingTmallResponse> {
	
	

	/** 
	* 商品ID，必填
	 */
	private Long itemId;

	/** 
	* skuId和sku状态的映射，其中状态1代表上架，-2代表下架，必填
	 */
	private String skuMap;

	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}

	public Long getItemId() {
		return this.itemId;
	}

	public void setSkuMap(String skuMap) {
		this.skuMap = skuMap;
	}
	public void setSkuMapString(String skuMap) {
		this.skuMap = skuMap;
	}

	public String getSkuMap() {
		return this.skuMap;
	}

	public String getApiMethodName() {
		return "taobao.sku.update.listing.tmall";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("item_id", this.itemId);
		txtParams.put("sku_map", this.skuMap);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<SkuUpdateListingTmallResponse> getResponseClass() {
		return SkuUpdateListingTmallResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(itemId, "itemId");
		RequestCheckUtils.checkNotEmpty(skuMap, "skuMap");
	}
	

}