package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.TopOaidMergeResponse;

/**
 * TOP API: taobao.top.oaid.merge request
 * 
 * @author top auto create
 * @since 1.0, 2021.11.03
 */
public class TopOaidMergeRequest extends BaseTaobaoRequest<TopOaidMergeResponse> {
	
	

	/** 
	* 合单请求列表，最多支持100个。
	 */
	private String mergeList;

	public void setMergeList(String mergeList) {
		this.mergeList = mergeList;
	}

	public void setMergeList(List<OrderMerge> mergeList) {
		this.mergeList = new JSONWriter(false,true).write(mergeList);
	}

	public String getMergeList() {
		return this.mergeList;
	}

	public String getApiMethodName() {
		return "taobao.top.oaid.merge";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("merge_list", this.mergeList);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TopOaidMergeResponse> getResponseClass() {
		return TopOaidMergeResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkObjectMaxListSize(mergeList, 999, "mergeList");
	}
	
	/**
 * 合单请求列表，最多支持100个。
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class OrderMerge extends TaobaoObject {

	private static final long serialVersionUID = 1412156485698823561L;

	/**
		 * 收件人ID (Open Addressee ID)，长度在128个字符之内。
		 */
		@ApiField("oaid")
		private String oaid;
		/**
		 * 订单ID
		 */
		@ApiField("tid")
		private String tid;
	

	public String getOaid() {
			return this.oaid;
		}
		public void setOaid(String oaid) {
			this.oaid = oaid;
		}
		public String getTid() {
			return this.tid;
		}
		public void setTid(String tid) {
			this.tid = tid;
		}

}


}