package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.TradeInvoiceAmountGetResponse;

/**
 * TOP API: taobao.trade.invoice.amount.get request
 * 
 * @author top auto create
 * @since 1.0, 2025.01.09
 */
public class TradeInvoiceAmountGetRequest extends BaseTaobaoRequest<TradeInvoiceAmountGetResponse> {
	
	

	/** 
	* 业务订单ID
	 */
	private Long tid;

	public void setTid(Long tid) {
		this.tid = tid;
	}

	public Long getTid() {
		return this.tid;
	}

	public String getApiMethodName() {
		return "taobao.trade.invoice.amount.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("tid", this.tid);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TradeInvoiceAmountGetResponse> getResponseClass() {
		return TradeInvoiceAmountGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(tid, "tid");
	}
	

}