package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.TradeWtverticalGetResponse;

/**
 * TOP API: taobao.trade.wtvertical.get request
 * 
 * @author top auto create
 * @since 1.0, 2024.01.05
 */
public class TradeWtverticalGetRequest extends BaseTaobaoRequest<TradeWtverticalGetResponse> {
	
	

	/** 
	* 主订单列表,用“，”分隔tid的字符串,最大列表长度为15
	 */
	private String tids;

	public void setTids(String tids) {
		this.tids = tids;
	}

	public String getTids() {
		return this.tids;
	}

	public String getApiMethodName() {
		return "taobao.trade.wtvertical.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("tids", this.tids);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TradeWtverticalGetResponse> getResponseClass() {
		return TradeWtverticalGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(tids, "tids");
		RequestCheckUtils.checkMaxListSize(tids, 15, "tids");
	}
	

}