package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.WlbWaybillIQuerydetailResponse;

/**
 * TOP API: taobao.wlb.waybill.i.querydetail request
 * 
 * @author top auto create
 * @since 1.0, 2022.09.20
 */
public class WlbWaybillIQuerydetailRequest extends BaseTaobaoRequest<WlbWaybillIQuerydetailResponse> {
	
	

	/** 
	* 面单查询请求
	 */
	private String waybillDetailQueryRequest;

	public void setWaybillDetailQueryRequest(String waybillDetailQueryRequest) {
		this.waybillDetailQueryRequest = waybillDetailQueryRequest;
	}

	public void setWaybillDetailQueryRequest(WaybillDetailQueryRequest waybillDetailQueryRequest) {
		this.waybillDetailQueryRequest = new JSONWriter(false,true).write(waybillDetailQueryRequest);
	}

	public String getWaybillDetailQueryRequest() {
		return this.waybillDetailQueryRequest;
	}

	public String getApiMethodName() {
		return "taobao.wlb.waybill.i.querydetail";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("waybill_detail_query_request", this.waybillDetailQueryRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<WlbWaybillIQuerydetailResponse> getResponseClass() {
		return WlbWaybillIQuerydetailResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 面单查询请求
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class WaybillDetailQueryRequest extends TaobaoObject {

	private static final long serialVersionUID = 2541183522942243338L;

	/**
		 * CP快递公司编码
		 */
		@ApiField("cp_code")
		private String cpCode;
		/**
		 * 0:根据cp_code和waybil_code查询;1:根据订单号查询(默认根据cp_code和waybill_code查询)
		 */
		@ApiField("query_by")
		private Long queryBy;
		/**
		 * 需要查询的订单号
		 */
		@ApiListField("trade_order_list")
		@ApiField("string")
		private List<String> tradeOrderList;
		/**
		 * 电子面单单号
		 */
		@ApiListField("waybill_codes")
		@ApiField("string")
		private List<String> waybillCodes;
	

	public String getCpCode() {
			return this.cpCode;
		}
		public void setCpCode(String cpCode) {
			this.cpCode = cpCode;
		}
		public Long getQueryBy() {
			return this.queryBy;
		}
		public void setQueryBy(Long queryBy) {
			this.queryBy = queryBy;
		}
		public List<String> getTradeOrderList() {
			return this.tradeOrderList;
		}
		public void setTradeOrderList(List<String> tradeOrderList) {
			this.tradeOrderList = tradeOrderList;
		}
		public List<String> getWaybillCodes() {
			return this.waybillCodes;
		}
		public void setWaybillCodes(List<String> waybillCodes) {
			this.waybillCodes = waybillCodes;
		}

}


}