package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.WttTradeServiceGetResponse;

/**
 * TOP API: taobao.wtt.trade.service.get request
 * 
 * @author top auto create
 * @since 1.0, 2022.12.14
 */
public class WttTradeServiceGetRequest extends BaseTaobaoRequest<WttTradeServiceGetResponse> {
	
	

	/** 
	* 订单ID
	 */
	private Long bizOrder;

	public void setBizOrder(Long bizOrder) {
		this.bizOrder = bizOrder;
	}

	public Long getBizOrder() {
		return this.bizOrder;
	}

	public String getApiMethodName() {
		return "taobao.wtt.trade.service.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("biz_order", this.bizOrder);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<WttTradeServiceGetResponse> getResponseClass() {
		return WttTradeServiceGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(bizOrder, "bizOrder");
	}
	

}