package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: alibaba.ascp.logistics.cp.get response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class AlibabaAscpLogisticsCpGetResponse extends TaobaoResponse {

	private static final long serialVersionUID = 6854769112745428267L;

	/** 
	 * 返回值
	 */
	@ApiField("result")
	private ResultDTO result;


	public void setResult(ResultDTO result) {
		this.result = result;
	}
	public ResultDTO getResult( ) {
		return this.result;
	}
	
	/**
 * 快递公司资源列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class LogisticsResourceDTO extends TaobaoObject {

	private static final long serialVersionUID = 3886954422839564964L;

	/**
		 * 快递公司id
		 */
		@ApiField("company_id")
		private Long companyId;
		/**
		 * 运单号校验正则表达式
		 */
		@ApiField("reg_mail_no")
		private String regMailNo;
		/**
		 * 快递资源编码
		 */
		@ApiField("resource_code")
		private String resourceCode;
		/**
		 * 快递资源名称
		 */
		@ApiField("resource_name")
		private String resourceName;
	

	public Long getCompanyId() {
			return this.companyId;
		}
		public void setCompanyId(Long companyId) {
			this.companyId = companyId;
		}
		public String getRegMailNo() {
			return this.regMailNo;
		}
		public void setRegMailNo(String regMailNo) {
			this.regMailNo = regMailNo;
		}
		public String getResourceCode() {
			return this.resourceCode;
		}
		public void setResourceCode(String resourceCode) {
			this.resourceCode = resourceCode;
		}
		public String getResourceName() {
			return this.resourceName;
		}
		public void setResourceName(String resourceName) {
			this.resourceName = resourceName;
		}

}

	/**
 * 返回值
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ResultDTO extends TaobaoObject {

	private static final long serialVersionUID = 3325261677588689347L;

	/**
		 * 错误码
		 */
		@ApiField("error_code")
		private String errorCode;
		/**
		 * 错误信息
		 */
		@ApiField("error_desc")
		private String errorDesc;
		/**
		 * 快递公司资源列表
		 */
		@ApiListField("resource_list")
		@ApiField("logistics_resource_d_t_o")
		private List<LogisticsResourceDTO> resourceList;
		/**
		 * 调用是否成功
		 */
		@ApiField("success")
		private Boolean success;
	

	public String getErrorCode() {
			return this.errorCode;
		}
		public void setErrorCode(String errorCode) {
			this.errorCode = errorCode;
		}
		public String getErrorDesc() {
			return this.errorDesc;
		}
		public void setErrorDesc(String errorDesc) {
			this.errorDesc = errorDesc;
		}
		public List<LogisticsResourceDTO> getResourceList() {
			return this.resourceList;
		}
		public void setResourceList(List<LogisticsResourceDTO> resourceList) {
			this.resourceList = resourceList;
		}
		public Boolean getSuccess() {
			return this.success;
		}
		public void setSuccess(Boolean success) {
			this.success = success;
		}

}



}
