package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: cainiao.reachable.batchjudge response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class CainiaoReachableBatchjudgeResponse extends TaobaoResponse {

	private static final long serialVersionUID = 7115836413478448113L;

	/** 
	 * 结果
	 */
	@ApiField("result")
	private BaseResultDto result;


	public void setResult(BaseResultDto result) {
		this.result = result;
	}
	public BaseResultDto getResult( ) {
		return this.result;
	}
	
	/**
 * 请求错误信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ErrorInfo extends TaobaoObject {

	private static final long serialVersionUID = 8621994152889418441L;

	/**
		 * 错误码
		 */
		@ApiField("error_code")
		private String errorCode;
		/**
		 * 错误信息
		 */
		@ApiField("error_message")
		private String errorMessage;
	

	public String getErrorCode() {
			return this.errorCode;
		}
		public void setErrorCode(String errorCode) {
			this.errorCode = errorCode;
		}
		public String getErrorMessage() {
			return this.errorMessage;
		}
		public void setErrorMessage(String errorMessage) {
			this.errorMessage = errorMessage;
		}

}

	/**
 * 可达信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ReachableDto extends TaobaoObject {

	private static final long serialVersionUID = 4249461368448393823L;

	/**
		 * 是否阻断 true:阻断  false:可达
		 */
		@ApiField("interrupt_apply_waybill_code")
		private Boolean interruptApplyWaybillCode;
		/**
		 * 阻断原因
		 */
		@ApiField("interrupt_reason")
		private String interruptReason;
	

	public Boolean getInterruptApplyWaybillCode() {
			return this.interruptApplyWaybillCode;
		}
		public void setInterruptApplyWaybillCode(Boolean interruptApplyWaybillCode) {
			this.interruptApplyWaybillCode = interruptApplyWaybillCode;
		}
		public String getInterruptReason() {
			return this.interruptReason;
		}
		public void setInterruptReason(String interruptReason) {
			this.interruptReason = interruptReason;
		}

}

	/**
 * 结果列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ReachableServiceWaybillResponseDto extends TaobaoObject {

	private static final long serialVersionUID = 4578187171777126851L;

	/**
		 * 单个结果是否异常
		 */
		@ApiField("error_info")
		private ErrorInfo errorInfo;
		/**
		 * 可达信息
		 */
		@ApiField("module")
		private ReachableDto module;
		/**
		 * 与入参地址列表中单项objectId对应
		 */
		@ApiField("object_id")
		private String objectId;
		/**
		 * 单个结果是否成功
		 */
		@ApiField("success")
		private Boolean success;
	

	public ErrorInfo getErrorInfo() {
			return this.errorInfo;
		}
		public void setErrorInfo(ErrorInfo errorInfo) {
			this.errorInfo = errorInfo;
		}
		public ReachableDto getModule() {
			return this.module;
		}
		public void setModule(ReachableDto module) {
			this.module = module;
		}
		public String getObjectId() {
			return this.objectId;
		}
		public void setObjectId(String objectId) {
			this.objectId = objectId;
		}
		public Boolean getSuccess() {
			return this.success;
		}
		public void setSuccess(Boolean success) {
			this.success = success;
		}

}

	/**
 * 返回信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ReachableServiceWaybillForTopResponseDto extends TaobaoObject {

	private static final long serialVersionUID = 3291754197914961716L;

	/**
		 * 结果列表
		 */
		@ApiListField("result_list")
		@ApiField("reachable_service_waybill_response_dto")
		private List<ReachableServiceWaybillResponseDto> resultList;
	

	public List<ReachableServiceWaybillResponseDto> getResultList() {
			return this.resultList;
		}
		public void setResultList(List<ReachableServiceWaybillResponseDto> resultList) {
			this.resultList = resultList;
		}

}

	/**
 * 结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class BaseResultDto extends TaobaoObject {

	private static final long serialVersionUID = 7271865826484537388L;

	/**
		 * 返回信息
		 */
		@ApiField("module")
		private ReachableServiceWaybillForTopResponseDto module;
		/**
		 * 请求错误信息
		 */
		@ApiField("one_error_info")
		private ErrorInfo oneErrorInfo;
		/**
		 * 请求是否成功
		 */
		@ApiField("success")
		private Boolean success;
	

	public ReachableServiceWaybillForTopResponseDto getModule() {
			return this.module;
		}
		public void setModule(ReachableServiceWaybillForTopResponseDto module) {
			this.module = module;
		}
		public ErrorInfo getOneErrorInfo() {
			return this.oneErrorInfo;
		}
		public void setOneErrorInfo(ErrorInfo oneErrorInfo) {
			this.oneErrorInfo = oneErrorInfo;
		}
		public Boolean getSuccess() {
			return this.success;
		}
		public void setSuccess(Boolean success) {
			this.success = success;
		}

}



}
