package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: cainiao.waybill.ii.get response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class CainiaoWaybillIiGetResponse extends TaobaoResponse {

	private static final long serialVersionUID = 7757419866164449669L;

	/** 
	 * 系统自动生成
	 */
	@ApiListField("modules")
	@ApiField("waybill_cloud_print_response")
	private List<WaybillCloudPrintResponse> modules;


	public void setModules(List<WaybillCloudPrintResponse> modules) {
		this.modules = modules;
	}
	public List<WaybillCloudPrintResponse> getModules( ) {
		return this.modules;
	}
	
	/**
 * 系统自动生成
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class WaybillCloudPrintResponse extends TaobaoObject {

	private static final long serialVersionUID = 1371687833579939544L;

	/**
		 * cp_code，跟入参传入的cp_code保持一致
		 */
		@ApiField("cp_code")
		private String cpCode;
		/**
		 * 拓展信息，特殊场景下使用
		 */
		@ApiField("extra_info")
		private String extraInfo;
		/**
		 * 请求id
		 */
		@ApiField("object_id")
		private String objectId;
		/**
		 * 子母件中的母单号，当为子母件模式时，需要此单号为实际挂载物流详情的单号，需要使用此单号进行发货，查询物流详情，非子母件，此字段为空
		 */
		@ApiField("parent_waybill_code")
		private String parentWaybillCode;
		/**
		 * 云打印内容（encryptedData表示加密结果，data表示非加密结果）;模板内容,具体解释见<a href="http:open.taobao.comdoc2detail.htm?spm=a219a.7629140.0.0.8cf9Nj&treeId=17&articleId=105085&docType=1#12">链接<a>
		 */
		@ApiField("print_data")
		private String printData;
		/**
		 * 真实取号的cp_code，在淘特官方物流等虚拟cp的场景中real_cp_code和入参中的cp_code不一样，其他场景二者一样
		 */
		@ApiField("real_cp_code")
		private String realCpCode;
		/**
		 * 面单号, 子母件模式下为子面单号
		 */
		@ApiField("waybill_code")
		private String waybillCode;
	

	public String getCpCode() {
			return this.cpCode;
		}
		public void setCpCode(String cpCode) {
			this.cpCode = cpCode;
		}
		public String getExtraInfo() {
			return this.extraInfo;
		}
		public void setExtraInfo(String extraInfo) {
			this.extraInfo = extraInfo;
		}
		public String getObjectId() {
			return this.objectId;
		}
		public void setObjectId(String objectId) {
			this.objectId = objectId;
		}
		public String getParentWaybillCode() {
			return this.parentWaybillCode;
		}
		public void setParentWaybillCode(String parentWaybillCode) {
			this.parentWaybillCode = parentWaybillCode;
		}
		public String getPrintData() {
			return this.printData;
		}
		public void setPrintData(String printData) {
			this.printData = printData;
		}
		public String getRealCpCode() {
			return this.realCpCode;
		}
		public void setRealCpCode(String realCpCode) {
			this.realCpCode = realCpCode;
		}
		public String getWaybillCode() {
			return this.waybillCode;
		}
		public void setWaybillCode(String waybillCode) {
			this.waybillCode = waybillCode;
		}

}



}
