package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Date;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: taobao.fenxiao.refund.query response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class FenxiaoRefundQueryResponse extends TaobaoResponse {

	private static final long serialVersionUID = 4732552737431393196L;

	/** 
	 * 退款列表
	 */
	@ApiListField("refund_list")
	@ApiField("refund_detail")
	private List<RefundDetail> refundList;

	/** 
	 * 按查询条件查到的记录总数
	 */
	@ApiField("total_results")
	private Long totalResults;


	public void setRefundList(List<RefundDetail> refundList) {
		this.refundList = refundList;
	}
	public List<RefundDetail> getRefundList( ) {
		return this.refundList;
	}

	public void setTotalResults(Long totalResults) {
		this.totalResults = totalResults;
	}
	public Long getTotalResults( ) {
		return this.totalResults;
	}
	
	/**
 * 前台消费者订单对应的退款详情
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class BuyerRefund extends TaobaoObject {

	private static final long serialVersionUID = 3492829331466678894L;

	/**
		 * 消费者订单退款涉及的消费者正向子订单号
		 */
		@ApiField("biz_order_id")
		private Long bizOrderId;
		/**
		 * 下游买家nick
		 */
		@ApiField("buyer_nick")
		private String buyerNick;
		/**
		 * 货物的状态：买家已收到货买家已退货买家未收到货
		 */
		@ApiField("goods_status_desc")
		private String goodsStatusDesc;
		/**
		 * 消费者退款修改时间。格式:yyyy-MM-dd HH:mm:ss
		 */
		@ApiField("modified")
		private Date modified;
		/**
		 * 买家是否退货
		 */
		@ApiField("need_return_goods")
		private Boolean needReturnGoods;
		/**
		 * 消费者买家id加密key
		 */
		@ApiField("open_buyer_id")
		private String openBuyerId;
		/**
		 * 消费者订单退款创建时间
		 */
		@ApiField("refund_create_time")
		private Date refundCreateTime;
		/**
		 * 消费者退款说明
		 */
		@ApiField("refund_desc")
		private String refundDesc;
		/**
		 * 消费者订单对应的退款单号
		 */
		@ApiField("refund_id")
		private Long refundId;
		/**
		 * 消费者退款原因
		 */
		@ApiField("refund_reason")
		private String refundReason;
		/**
		 * 消费者订单退款状态 1、消费者已经申请退款，等待分销商确认 2、分销商已经同意退货，等待消费者退货  3、消费者已经退货，等待分销商确认收货 4、退款关闭   5、退款成功 6、分销商拒绝退款,待消费者重新修改  7、等待消费者确认重新邮寄的货物  
		 */
		@ApiField("refund_status")
		private Long refundStatus;
		/**
		 * 退还给消费者的金额(分)
		 */
		@ApiField("return_fee")
		private Long returnFee;
		/**
		 * 消费者退货数量
		 */
		@ApiField("return_goods_quantity")
		private Long returnGoodsQuantity;
		/**
		 * 分销子订单号
		 */
		@ApiField("sub_order_id")
		private Long subOrderId;
		/**
		 * 确认收货后会打款给分销商的金额(分),分摊到子单的实付金额-退款给消费者的金额
		 */
		@ApiField("to_seller_fee")
		private Long toSellerFee;
	

	public Long getBizOrderId() {
			return this.bizOrderId;
		}
		public void setBizOrderId(Long bizOrderId) {
			this.bizOrderId = bizOrderId;
		}
		public String getBuyerNick() {
			return this.buyerNick;
		}
		public void setBuyerNick(String buyerNick) {
			this.buyerNick = buyerNick;
		}
		public String getGoodsStatusDesc() {
			return this.goodsStatusDesc;
		}
		public void setGoodsStatusDesc(String goodsStatusDesc) {
			this.goodsStatusDesc = goodsStatusDesc;
		}
		public Date getModified() {
			return this.modified;
		}
		public void setModified(Date modified) {
			this.modified = modified;
		}
		public Boolean getNeedReturnGoods() {
			return this.needReturnGoods;
		}
		public void setNeedReturnGoods(Boolean needReturnGoods) {
			this.needReturnGoods = needReturnGoods;
		}
		public String getOpenBuyerId() {
			return this.openBuyerId;
		}
		public void setOpenBuyerId(String openBuyerId) {
			this.openBuyerId = openBuyerId;
		}
		public Date getRefundCreateTime() {
			return this.refundCreateTime;
		}
		public void setRefundCreateTime(Date refundCreateTime) {
			this.refundCreateTime = refundCreateTime;
		}
		public String getRefundDesc() {
			return this.refundDesc;
		}
		public void setRefundDesc(String refundDesc) {
			this.refundDesc = refundDesc;
		}
		public Long getRefundId() {
			return this.refundId;
		}
		public void setRefundId(Long refundId) {
			this.refundId = refundId;
		}
		public String getRefundReason() {
			return this.refundReason;
		}
		public void setRefundReason(String refundReason) {
			this.refundReason = refundReason;
		}
		public Long getRefundStatus() {
			return this.refundStatus;
		}
		public void setRefundStatus(Long refundStatus) {
			this.refundStatus = refundStatus;
		}
		public Long getReturnFee() {
			return this.returnFee;
		}
		public void setReturnFee(Long returnFee) {
			this.returnFee = returnFee;
		}
		public Long getReturnGoodsQuantity() {
			return this.returnGoodsQuantity;
		}
		public void setReturnGoodsQuantity(Long returnGoodsQuantity) {
			this.returnGoodsQuantity = returnGoodsQuantity;
		}
		public Long getSubOrderId() {
			return this.subOrderId;
		}
		public void setSubOrderId(Long subOrderId) {
			this.subOrderId = subOrderId;
		}
		public Long getToSellerFee() {
			return this.toSellerFee;
		}
		public void setToSellerFee(Long toSellerFee) {
			this.toSellerFee = toSellerFee;
		}

}

	/**
 * 退款明细项，记录退款涉及的订单
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class RefundLogistics extends TaobaoObject {

	private static final long serialVersionUID = 4164977988557293774L;

	/**
		 * 退货物流公司编码，如顺丰、韵达等
		 */
		@ApiField("company_code")
		private String companyCode;
		/**
		 * 退货物流公司名称，如顺丰
		 */
		@ApiField("company_name")
		private String companyName;
		/**
		 * 退货物流运单号
		 */
		@ApiField("mail_no")
		private String mailNo;
	

	public String getCompanyCode() {
			return this.companyCode;
		}
		public void setCompanyCode(String companyCode) {
			this.companyCode = companyCode;
		}
		public String getCompanyName() {
			return this.companyName;
		}
		public void setCompanyName(String companyName) {
			this.companyName = companyName;
		}
		public String getMailNo() {
			return this.mailNo;
		}
		public void setMailNo(String mailNo) {
			this.mailNo = mailNo;
		}

}

	/**
 * 退款明细项，记录退款涉及的订单
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class RefundItem extends TaobaoObject {

	private static final long serialVersionUID = 6796588726431347759L;

	/**
		 * 退款明细ID，针对一笔退款每一个品就映射为一个明细，每一个明细有一个全局唯一的ID
		 */
		@ApiField("refund_item_id")
		private Long refundItemId;
		/**
		 * 退货数量
		 */
		@ApiField("refund_quantity")
		private Long refundQuantity;
		/**
		 * 分销子订单号
		 */
		@ApiField("sub_order_id")
		private Long subOrderId;
	

	public Long getRefundItemId() {
			return this.refundItemId;
		}
		public void setRefundItemId(Long refundItemId) {
			this.refundItemId = refundItemId;
		}
		public Long getRefundQuantity() {
			return this.refundQuantity;
		}
		public void setRefundQuantity(Long refundQuantity) {
			this.refundQuantity = refundQuantity;
		}
		public Long getSubOrderId() {
			return this.subOrderId;
		}
		public void setSubOrderId(Long subOrderId) {
			this.subOrderId = subOrderId;
		}

}

	/**
 * 退款列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class RefundDetail extends TaobaoObject {

	private static final long serialVersionUID = 3374382423817647675L;

	/**
		 * 前台消费者订单对应的退款详情
		 */
		@ApiField("buyer_refund")
		private BuyerRefund buyerRefund;
		/**
		 * 分销商nick
		 */
		@ApiField("distributor_nick")
		private String distributorNick;
		/**
		 * 是否退货,如果是已发货退货退款售后退货退款，就是true
		 */
		@ApiField("is_return_goods")
		private Boolean isReturnGoods;
		/**
		 * 退款修改时间。格式:yyyy-MM-dd HH:mm:ss
		 */
		@ApiField("modified")
		private Date modified;
		/**
		 * 支付给供应商的金额(元)，分销订单子单实付金额-退款金额
		 */
		@ApiField("pay_sup_fee")
		private String paySupFee;
		/**
		 * 分销主订单号
		 */
		@ApiField("purchase_order_id")
		private Long purchaseOrderId;
		/**
		 * 退款创建时间
		 */
		@ApiField("refund_create_time")
		private Date refundCreateTime;
		/**
		 * 退款说明
		 */
		@ApiField("refund_desc")
		private String refundDesc;
		/**
		 * 退款的金额(元)
		 */
		@ApiField("refund_fee")
		private String refundFee;
		/**
		 * 退款流程类型：4：发货前退款；1：发货后退款不退货；2：发货后退款退货；3：售后退款；5：拒收；6：售后退货退款
		 */
		@ApiField("refund_flow_type")
		private Long refundFlowType;
		/**
		 * 分销退款单号
		 */
		@ApiField("refund_id")
		private Long refundId;
		/**
		 * 退款明细项，记录退款涉及的订单
		 */
		@ApiListField("refund_items")
		@ApiField("refund_item")
		private List<RefundItem> refundItems;
		/**
		 * 退款原因
		 */
		@ApiField("refund_reason")
		private String refundReason;
		/**
		 * 退款状态1：分销商已经申请退款，等待供应商确认2：供应商已经同意退货，等待分销商退货3：分销商已经退货，等待供应商确认收货4：退款关闭5：退款成功  6：供应商拒绝退款12：供应商同意退款，待系统打款  9：没有申请退款 10：供应商拒绝确认收货,待分销商重新修改
		 */
		@ApiField("refund_status")
		private Long refundStatus;
		/**
		 * 退款明细项，记录退款涉及的订单
		 */
		@ApiListField("return_logistics")
		@ApiField("refund_logistics")
		private List<RefundLogistics> returnLogistics;
		/**
		 * 分销子订单号，如果是by子单发起退款，就会在退款主单上记录分销子订单号
		 */
		@ApiField("sub_order_id")
		private Long subOrderId;
		/**
		 * 供应商nick
		 */
		@ApiField("supplier_nick")
		private String supplierNick;
		/**
		 * 超时时间
		 */
		@ApiField("timeout")
		private Date timeout;
		/**
		 * 超时类型：
	1：供应商同意退款同意退货超时；
	2：供应商确认收货超时
		 */
		@ApiField("to_type")
		private Long toType;
	

	public BuyerRefund getBuyerRefund() {
			return this.buyerRefund;
		}
		public void setBuyerRefund(BuyerRefund buyerRefund) {
			this.buyerRefund = buyerRefund;
		}
		public String getDistributorNick() {
			return this.distributorNick;
		}
		public void setDistributorNick(String distributorNick) {
			this.distributorNick = distributorNick;
		}
		public Boolean getIsReturnGoods() {
			return this.isReturnGoods;
		}
		public void setIsReturnGoods(Boolean isReturnGoods) {
			this.isReturnGoods = isReturnGoods;
		}
		public Date getModified() {
			return this.modified;
		}
		public void setModified(Date modified) {
			this.modified = modified;
		}
		public String getPaySupFee() {
			return this.paySupFee;
		}
		public void setPaySupFee(String paySupFee) {
			this.paySupFee = paySupFee;
		}
		public Long getPurchaseOrderId() {
			return this.purchaseOrderId;
		}
		public void setPurchaseOrderId(Long purchaseOrderId) {
			this.purchaseOrderId = purchaseOrderId;
		}
		public Date getRefundCreateTime() {
			return this.refundCreateTime;
		}
		public void setRefundCreateTime(Date refundCreateTime) {
			this.refundCreateTime = refundCreateTime;
		}
		public String getRefundDesc() {
			return this.refundDesc;
		}
		public void setRefundDesc(String refundDesc) {
			this.refundDesc = refundDesc;
		}
		public String getRefundFee() {
			return this.refundFee;
		}
		public void setRefundFee(String refundFee) {
			this.refundFee = refundFee;
		}
		public Long getRefundFlowType() {
			return this.refundFlowType;
		}
		public void setRefundFlowType(Long refundFlowType) {
			this.refundFlowType = refundFlowType;
		}
		public Long getRefundId() {
			return this.refundId;
		}
		public void setRefundId(Long refundId) {
			this.refundId = refundId;
		}
		public List<RefundItem> getRefundItems() {
			return this.refundItems;
		}
		public void setRefundItems(List<RefundItem> refundItems) {
			this.refundItems = refundItems;
		}
		public String getRefundReason() {
			return this.refundReason;
		}
		public void setRefundReason(String refundReason) {
			this.refundReason = refundReason;
		}
		public Long getRefundStatus() {
			return this.refundStatus;
		}
		public void setRefundStatus(Long refundStatus) {
			this.refundStatus = refundStatus;
		}
		public List<RefundLogistics> getReturnLogistics() {
			return this.returnLogistics;
		}
		public void setReturnLogistics(List<RefundLogistics> returnLogistics) {
			this.returnLogistics = returnLogistics;
		}
		public Long getSubOrderId() {
			return this.subOrderId;
		}
		public void setSubOrderId(Long subOrderId) {
			this.subOrderId = subOrderId;
		}
		public String getSupplierNick() {
			return this.supplierNick;
		}
		public void setSupplierNick(String supplierNick) {
			this.supplierNick = supplierNick;
		}
		public Date getTimeout() {
			return this.timeout;
		}
		public void setTimeout(Date timeout) {
			this.timeout = timeout;
		}
		public Long getToType() {
			return this.toType;
		}
		public void setToType(Long toType) {
			this.toType = toType;
		}

}



}
