package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: taobao.jst.astrolabe.storeinventory.itemquery response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class JstAstrolabeStoreinventoryItemqueryResponse extends TaobaoResponse {

	private static final long serialVersionUID = 4153713741352232495L;

	/** 
	 * 响应标示
	 */
	@ApiField("flag")
	private String flag;

	/** 
	 * message
	 */
	@ApiField("message")
	private String message;

	/** 
	 * 响应编码
	 */
	@ApiField("qimen_code")
	private String qimenCode;

	/** 
	 * 门店列表
	 */
	@ApiListField("stores")
	@ApiField("store")
	private List<Store> stores;


	public void setFlag(String flag) {
		this.flag = flag;
	}
	public String getFlag( ) {
		return this.flag;
	}

	public void setMessage(String message) {
		this.message = message;
	}
	public String getMessage( ) {
		return this.message;
	}

	public void setQimenCode(String qimenCode) {
		this.qimenCode = qimenCode;
	}
	public String getQimenCode( ) {
		return this.qimenCode;
	}

	public void setStores(List<Store> stores) {
		this.stores = stores;
	}
	public List<Store> getStores( ) {
		return this.stores;
	}
	
	/**
 * 库存量详情列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class QuantityDetail extends TaobaoObject {

	private static final long serialVersionUID = 4367691376616438756L;

	/**
		 * 库存类型
		 */
		@ApiField("inventory_type")
		private String inventoryType;
		/**
		 * 占用库存
		 */
		@ApiField("occupy_quantity")
		private Long occupyQuantity;
		/**
		 * 库存数量
		 */
		@ApiField("quantity")
		private Long quantity;
	

	public String getInventoryType() {
			return this.inventoryType;
		}
		public void setInventoryType(String inventoryType) {
			this.inventoryType = inventoryType;
		}
		public Long getOccupyQuantity() {
			return this.occupyQuantity;
		}
		public void setOccupyQuantity(Long occupyQuantity) {
			this.occupyQuantity = occupyQuantity;
		}
		public Long getQuantity() {
			return this.quantity;
		}
		public void setQuantity(Long quantity) {
			this.quantity = quantity;
		}

}

	/**
 * 门店库存列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class StoreInventory extends TaobaoObject {

	private static final long serialVersionUID = 5793262134378846211L;

	/**
		 * 淘宝前端商品id
		 */
		@ApiField("item_id")
		private String itemId;
		/**
		 * ISV系统中商品编码
		 */
		@ApiField("outer_id")
		private String outerId;
		/**
		 * 库存量详情列表
		 */
		@ApiListField("quantity_details")
		@ApiField("quantity_detail")
		private List<QuantityDetail> quantityDetails;
		/**
		 * 商品的SKU编码
		 */
		@ApiField("sku_id")
		private String skuId;
	

	public String getItemId() {
			return this.itemId;
		}
		public void setItemId(String itemId) {
			this.itemId = itemId;
		}
		public String getOuterId() {
			return this.outerId;
		}
		public void setOuterId(String outerId) {
			this.outerId = outerId;
		}
		public List<QuantityDetail> getQuantityDetails() {
			return this.quantityDetails;
		}
		public void setQuantityDetails(List<QuantityDetail> quantityDetails) {
			this.quantityDetails = quantityDetails;
		}
		public String getSkuId() {
			return this.skuId;
		}
		public void setSkuId(String skuId) {
			this.skuId = skuId;
		}

}

	/**
 * 门店列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Store extends TaobaoObject {

	private static final long serialVersionUID = 7681589517522458479L;

	/**
		 * 门店库存列表
		 */
		@ApiListField("store_inventories")
		@ApiField("store_inventory")
		private List<StoreInventory> storeInventories;
		/**
		 * 门店ID(商户中心) 或 电商仓ID
		 */
		@ApiField("warehouse_id")
		private String warehouseId;
		/**
		 * 库存来源
		 */
		@ApiField("warehouse_type")
		private String warehouseType;
	

	public List<StoreInventory> getStoreInventories() {
			return this.storeInventories;
		}
		public void setStoreInventories(List<StoreInventory> storeInventories) {
			this.storeInventories = storeInventories;
		}
		public String getWarehouseId() {
			return this.warehouseId;
		}
		public void setWarehouseId(String warehouseId) {
			this.warehouseId = warehouseId;
		}
		public String getWarehouseType() {
			return this.warehouseType;
		}
		public void setWarehouseType(String warehouseType) {
			this.warehouseType = warehouseType;
		}

}



}
