package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: taobao.jst.astrolabe.storeinventory.query response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class JstAstrolabeStoreinventoryQueryResponse extends TaobaoResponse {

	private static final long serialVersionUID = 1896821737998116892L;

	/** 
	 * 响应标示
	 */
	@ApiField("flag")
	private String flag;

	/** 
	 * 响应信息
	 */
	@ApiField("message")
	private String message;

	/** 
	 * 响应编码
	 */
	@ApiField("result_code")
	private String resultCode;

	/** 
	 * 门店列表
	 */
	@ApiListField("stores")
	@ApiField("store")
	private List<Store> stores;


	public void setFlag(String flag) {
		this.flag = flag;
	}
	public String getFlag( ) {
		return this.flag;
	}

	public void setMessage(String message) {
		this.message = message;
	}
	public String getMessage( ) {
		return this.message;
	}

	public void setResultCode(String resultCode) {
		this.resultCode = resultCode;
	}
	public String getResultCode( ) {
		return this.resultCode;
	}

	public void setStores(List<Store> stores) {
		this.stores = stores;
	}
	public List<Store> getStores( ) {
		return this.stores;
	}
	
	/**
 * 库存量详情
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class QuantityDetail extends TaobaoObject {

	private static final long serialVersionUID = 7446426334163816183L;

	/**
		 * 库存类型
		 */
		@ApiField("inventory_type")
		private String inventoryType;
		/**
		 * 当前类型库存数量
		 */
		@ApiField("quantity")
		private String quantity;
	

	public String getInventoryType() {
			return this.inventoryType;
		}
		public void setInventoryType(String inventoryType) {
			this.inventoryType = inventoryType;
		}
		public String getQuantity() {
			return this.quantity;
		}
		public void setQuantity(String quantity) {
			this.quantity = quantity;
		}

}

	/**
 * 门店库存信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class StoreInventory extends TaobaoObject {

	private static final long serialVersionUID = 6843866133797937933L;

	/**
		 * ISV系统中商品编码
		 */
		@ApiField("outer_id")
		private String outerId;
		/**
		 * 库存量详情
		 */
		@ApiListField("quantity_details")
		@ApiField("quantity_detail")
		private List<QuantityDetail> quantityDetails;
		/**
		 * 淘宝后端商品id
		 */
		@ApiField("sc_item_id")
		private String scItemId;
	

	public String getOuterId() {
			return this.outerId;
		}
		public void setOuterId(String outerId) {
			this.outerId = outerId;
		}
		public List<QuantityDetail> getQuantityDetails() {
			return this.quantityDetails;
		}
		public void setQuantityDetails(List<QuantityDetail> quantityDetails) {
			this.quantityDetails = quantityDetails;
		}
		public String getScItemId() {
			return this.scItemId;
		}
		public void setScItemId(String scItemId) {
			this.scItemId = scItemId;
		}

}

	/**
 * 门店列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Store extends TaobaoObject {

	private static final long serialVersionUID = 6536634558718692396L;

	/**
		 * 门店库存信息
		 */
		@ApiListField("store_inventories")
		@ApiField("store_inventory")
		private List<StoreInventory> storeInventories;
		/**
		 * 门店ID(商户中心) 或 电商仓ID
		 */
		@ApiField("warehouse_id")
		private String warehouseId;
		/**
		 * 库存来源
		 */
		@ApiField("warehouse_type")
		private String warehouseType;
	

	public List<StoreInventory> getStoreInventories() {
			return this.storeInventories;
		}
		public void setStoreInventories(List<StoreInventory> storeInventories) {
			this.storeInventories = storeInventories;
		}
		public String getWarehouseId() {
			return this.warehouseId;
		}
		public void setWarehouseId(String warehouseId) {
			this.warehouseId = warehouseId;
		}
		public String getWarehouseType() {
			return this.warehouseType;
		}
		public void setWarehouseType(String warehouseType) {
			this.warehouseType = warehouseType;
		}

}



}
