package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Date;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: taobao.jst.sms.task.create response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class JstSmsTaskCreateResponse extends TaobaoResponse {

	private static final long serialVersionUID = 1775641852223674161L;

	/** 
	 * 出参
	 */
	@ApiField("result")
	private SmsResponse result;


	public void setResult(SmsResponse result) {
		this.result = result;
	}
	public SmsResponse getResult( ) {
		return this.result;
	}
	
	/**
 * 出参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class SmsTaskModel extends TaobaoObject {

	private static final long serialVersionUID = 1121548877631822955L;

	/**
		 * appkey
		 */
		@ApiField("app_key")
		private String appKey;
		/**
		 * 短信文案
		 */
		@ApiListField("contents")
		@ApiField("string")
		private List<String> contents;
		/**
		 * 创建时间
		 */
		@ApiField("gmt_create")
		private Date gmtCreate;
		/**
		 * 修改时间
		 */
		@ApiField("gmt_modified")
		private Date gmtModified;
		/**
		 * isv淘宝nick
		 */
		@ApiField("isv_nick")
		private String isvNick;
		/**
		 * 商家淘宝nick
		 */
		@ApiField("seller_nick")
		private String sellerNick;
		/**
		 * 短信签名
		 */
		@ApiListField("sign_names")
		@ApiField("string")
		private List<String> signNames;
		/**
		 * 任务对应的短信类型 ：1--数字短信  2--权益短信  3--公众号短信
		 */
		@ApiField("sms_type")
		private String smsType;
		/**
		 * 系统分配的任务code
		 */
		@ApiField("task_code")
		private String taskCode;
		/**
		 * 短信模板code
		 */
		@ApiListField("template_codes")
		@ApiField("string")
		private List<String> templateCodes;
		/**
		 * 商品或店铺详情页H5长链地址
		 */
		@ApiField("url")
		private String url;
	

	public String getAppKey() {
			return this.appKey;
		}
		public void setAppKey(String appKey) {
			this.appKey = appKey;
		}
		public List<String> getContents() {
			return this.contents;
		}
		public void setContents(List<String> contents) {
			this.contents = contents;
		}
		public Date getGmtCreate() {
			return this.gmtCreate;
		}
		public void setGmtCreate(Date gmtCreate) {
			this.gmtCreate = gmtCreate;
		}
		public Date getGmtModified() {
			return this.gmtModified;
		}
		public void setGmtModified(Date gmtModified) {
			this.gmtModified = gmtModified;
		}
		public String getIsvNick() {
			return this.isvNick;
		}
		public void setIsvNick(String isvNick) {
			this.isvNick = isvNick;
		}
		public String getSellerNick() {
			return this.sellerNick;
		}
		public void setSellerNick(String sellerNick) {
			this.sellerNick = sellerNick;
		}
		public List<String> getSignNames() {
			return this.signNames;
		}
		public void setSignNames(List<String> signNames) {
			this.signNames = signNames;
		}
		public String getSmsType() {
			return this.smsType;
		}
		public void setSmsType(String smsType) {
			this.smsType = smsType;
		}
		public String getTaskCode() {
			return this.taskCode;
		}
		public void setTaskCode(String taskCode) {
			this.taskCode = taskCode;
		}
		public List<String> getTemplateCodes() {
			return this.templateCodes;
		}
		public void setTemplateCodes(List<String> templateCodes) {
			this.templateCodes = templateCodes;
		}
		public String getUrl() {
			return this.url;
		}
		public void setUrl(String url) {
			this.url = url;
		}

}

	/**
 * 出参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class SmsResponse extends TaobaoObject {

	private static final long serialVersionUID = 4726298294629342825L;

	/**
		 * 请求成功
		 */
		@ApiField("code")
		private String code;
		/**
		 * 请求成功
		 */
		@ApiField("message")
		private String message;
		/**
		 * 出参
		 */
		@ApiField("module")
		private SmsTaskModel module;
		/**
		 * 请求ID
		 */
		@ApiField("request_id")
		private String requestId;
		/**
		 * 请求成功
		 */
		@ApiField("success")
		private Boolean success;
	

	public String getCode() {
			return this.code;
		}
		public void setCode(String code) {
			this.code = code;
		}
		public String getMessage() {
			return this.message;
		}
		public void setMessage(String message) {
			this.message = message;
		}
		public SmsTaskModel getModule() {
			return this.module;
		}
		public void setModule(SmsTaskModel module) {
			this.module = module;
		}
		public String getRequestId() {
			return this.requestId;
		}
		public void setRequestId(String requestId) {
			this.requestId = requestId;
		}
		public Boolean getSuccess() {
			return this.success;
		}
		public void setSuccess(Boolean success) {
			this.success = success;
		}

}



}
