package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: taobao.logistics.instant.trace.search response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class LogisticsInstantTraceSearchResponse extends TaobaoResponse {

	private static final long serialVersionUID = 3215666619457497462L;

	/** 
	 * 返回结果
	 */
	@ApiField("result")
	private Result result;


	public void setResult(Result result) {
		this.result = result;
	}
	public Result getResult( ) {
		return this.result;
	}
	
	/**
 * 物流节点列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopLogisticsNodeDTO extends TaobaoObject {

	private static final long serialVersionUID = 1511967939399981673L;

	/**
		 * 节点枚举
		 */
		@ApiField("action")
		private String action;
		/**
		 * 节点描述
		 */
		@ApiField("status_desc")
		private String statusDesc;
		/**
		 * 当前节点发生时间
		 */
		@ApiField("status_time")
		private Long statusTime;
	

	public String getAction() {
			return this.action;
		}
		public void setAction(String action) {
			this.action = action;
		}
		public String getStatusDesc() {
			return this.statusDesc;
		}
		public void setStatusDesc(String statusDesc) {
			this.statusDesc = statusDesc;
		}
		public Long getStatusTime() {
			return this.statusTime;
		}
		public void setStatusTime(Long statusTime) {
			this.statusTime = statusTime;
		}

}

	/**
 * 运单列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopLogisticsMailDTO extends TaobaoObject {

	private static final long serialVersionUID = 5145575584995919235L;

	/**
		 * 物流公司
		 */
		@ApiField("company_name")
		private String companyName;
		/**
		 * 运单号
		 */
		@ApiField("out_sid")
		private String outSid;
		/**
		 * 当前最新节点
		 */
		@ApiField("status")
		private String status;
		/**
		 * 交易单号
		 */
		@ApiField("tid")
		private Long tid;
		/**
		 * 物流节点列表
		 */
		@ApiListField("trace_list")
		@ApiField("top_logistics_node_d_t_o")
		private List<TopLogisticsNodeDTO> traceList;
	

	public String getCompanyName() {
			return this.companyName;
		}
		public void setCompanyName(String companyName) {
			this.companyName = companyName;
		}
		public String getOutSid() {
			return this.outSid;
		}
		public void setOutSid(String outSid) {
			this.outSid = outSid;
		}
		public String getStatus() {
			return this.status;
		}
		public void setStatus(String status) {
			this.status = status;
		}
		public Long getTid() {
			return this.tid;
		}
		public void setTid(Long tid) {
			this.tid = tid;
		}
		public List<TopLogisticsNodeDTO> getTraceList() {
			return this.traceList;
		}
		public void setTraceList(List<TopLogisticsNodeDTO> traceList) {
			this.traceList = traceList;
		}

}

	/**
 * 返回结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Result extends TaobaoObject {

	private static final long serialVersionUID = 6184374378447444158L;

	/**
		 * 运单列表
		 */
		@ApiListField("mail_list")
		@ApiField("top_logistics_mail_d_t_o")
		private List<TopLogisticsMailDTO> mailList;
		/**
		 * 是否成功
		 */
		@ApiField("success")
		private Boolean success;
	

	public List<TopLogisticsMailDTO> getMailList() {
			return this.mailList;
		}
		public void setMailList(List<TopLogisticsMailDTO> mailList) {
			this.mailList = mailList;
		}
		public Boolean getSuccess() {
			return this.success;
		}
		public void setSuccess(Boolean success) {
			this.success = success;
		}

}



}
