package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Date;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: taobao.omniorder.store.sdtquerystation response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class OmniorderStoreSdtquerystationResponse extends TaobaoResponse {

	private static final long serialVersionUID = 1393749349589379716L;

	/** 
	 * result
	 */
	@ApiField("result")
	private Result result;


	public void setResult(Result result) {
		this.result = result;
	}
	public Result getResult( ) {
		return this.result;
	}
	
	/**
 * 站点信息
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class SdtStationDto extends TaobaoObject {

	private static final long serialVersionUID = 2231938998534582727L;

	/**
		 * 站点操作时间
		 */
		@ApiField("action_time")
		private Date actionTime;
		/**
		 * 快递公司cpcode
		 */
		@ApiField("cp_code")
		private String cpCode;
		/**
		 * 快递公司名称
		 */
		@ApiField("cp_name")
		private String cpName;
		/**
		 * 站点code
		 */
		@ApiField("station_code")
		private String stationCode;
		/**
		 * 站点联系方式
		 */
		@ApiField("station_contact")
		private String stationContact;
		/**
		 * 站点负责人
		 */
		@ApiField("station_master")
		private String stationMaster;
		/**
		 * 站点名
		 */
		@ApiField("station_name")
		private String stationName;
		/**
		 * 站点类别（推荐站点、派送站点、揽收站点）
		 */
		@ApiField("type")
		private String type;
	

	public Date getActionTime() {
			return this.actionTime;
		}
		public void setActionTime(Date actionTime) {
			this.actionTime = actionTime;
		}
		public String getCpCode() {
			return this.cpCode;
		}
		public void setCpCode(String cpCode) {
			this.cpCode = cpCode;
		}
		public String getCpName() {
			return this.cpName;
		}
		public void setCpName(String cpName) {
			this.cpName = cpName;
		}
		public String getStationCode() {
			return this.stationCode;
		}
		public void setStationCode(String stationCode) {
			this.stationCode = stationCode;
		}
		public String getStationContact() {
			return this.stationContact;
		}
		public void setStationContact(String stationContact) {
			this.stationContact = stationContact;
		}
		public String getStationMaster() {
			return this.stationMaster;
		}
		public void setStationMaster(String stationMaster) {
			this.stationMaster = stationMaster;
		}
		public String getStationName() {
			return this.stationName;
		}
		public void setStationName(String stationName) {
			this.stationName = stationName;
		}
		public String getType() {
			return this.type;
		}
		public void setType(String type) {
			this.type = type;
		}

}

	/**
 * data
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class SdtQueryPackageResponse extends TaobaoObject {

	private static final long serialVersionUID = 2147924894322419653L;

	/**
		 * 站点信息
		 */
		@ApiListField("stations")
		@ApiField("sdt_station_dto")
		private List<SdtStationDto> stations;
	

	public List<SdtStationDto> getStations() {
			return this.stations;
		}
		public void setStations(List<SdtStationDto> stations) {
			this.stations = stations;
		}

}

	/**
 * result
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Result extends TaobaoObject {

	private static final long serialVersionUID = 6167387873293281771L;

	/**
		 * data
		 */
		@ApiField("data")
		private SdtQueryPackageResponse data;
		/**
		 * 错误码
		 */
		@ApiField("err_code")
		private String errCode;
		/**
		 * 错误信息
		 */
		@ApiField("err_msg")
		private String errMsg;
	

	public SdtQueryPackageResponse getData() {
			return this.data;
		}
		public void setData(SdtQueryPackageResponse data) {
			this.data = data;
		}
		public String getErrCode() {
			return this.errCode;
		}
		public void setErrCode(String errCode) {
			this.errCode = errCode;
		}
		public String getErrMsg() {
			return this.errMsg;
		}
		public void setErrMsg(String errMsg) {
			this.errMsg = errMsg;
		}

}



}
