package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: taobao.refund.negotiatereturn.render response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class RefundNegotiatereturnRenderResponse extends TaobaoResponse {

	private static final long serialVersionUID = 1725379793842434575L;

	/** 
	 * 卖家退货地址列表
	 */
	@ApiListField("address_list")
	@ApiField("address")
	private List<Address> addressList;

	/** 
	 * 申请协商提示文案
	 */
	@ApiField("apply_tips")
	private String applyTips;

	/** 
	 * 可以协商的最大退款金额
	 */
	@ApiField("max_refund_fee")
	private MaxRefundFee maxRefundFee;

	/** 
	 * 可以协商的退款原因列表
	 */
	@ApiListField("reason_list")
	@ApiField("reason")
	private List<Reason> reasonList;

	/** 
	 * 退款版本号
	 */
	@ApiField("refund_version")
	private Long refundVersion;


	public void setAddressList(List<Address> addressList) {
		this.addressList = addressList;
	}
	public List<Address> getAddressList( ) {
		return this.addressList;
	}

	public void setApplyTips(String applyTips) {
		this.applyTips = applyTips;
	}
	public String getApplyTips( ) {
		return this.applyTips;
	}

	public void setMaxRefundFee(MaxRefundFee maxRefundFee) {
		this.maxRefundFee = maxRefundFee;
	}
	public MaxRefundFee getMaxRefundFee( ) {
		return this.maxRefundFee;
	}

	public void setReasonList(List<Reason> reasonList) {
		this.reasonList = reasonList;
	}
	public List<Reason> getReasonList( ) {
		return this.reasonList;
	}

	public void setRefundVersion(Long refundVersion) {
		this.refundVersion = refundVersion;
	}
	public Long getRefundVersion( ) {
		return this.refundVersion;
	}
	
	/**
 * 可以协商的退款原因列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Reason extends TaobaoObject {

	private static final long serialVersionUID = 2659138692931278324L;

	/**
		 * 退款原因ID
		 */
		@ApiField("reason_id")
		private Long reasonId;
		/**
		 * 退款原因文案
		 */
		@ApiField("reason_text")
		private String reasonText;
	

	public Long getReasonId() {
			return this.reasonId;
		}
		public void setReasonId(Long reasonId) {
			this.reasonId = reasonId;
		}
		public String getReasonText() {
			return this.reasonText;
		}
		public void setReasonText(String reasonText) {
			this.reasonText = reasonText;
		}

}

	/**
 * 可以协商的最大退款金额
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class MaxRefundFee extends TaobaoObject {

	private static final long serialVersionUID = 8634688475115229784L;

	/**
		 * 可以协商的最大退款金额
		 */
		@ApiField("max_refund_fee")
		private Long maxRefundFee;
	

	public Long getMaxRefundFee() {
			return this.maxRefundFee;
		}
		public void setMaxRefundFee(Long maxRefundFee) {
			this.maxRefundFee = maxRefundFee;
		}

}

	/**
 * 卖家退货地址列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Address extends TaobaoObject {

	private static final long serialVersionUID = 4884574724763561949L;

	/**
		 * 乡镇街道地址详情
		 */
		@ApiField("address_detail")
		private String addressDetail;
		/**
		 * 地址ID
		 */
		@ApiField("address_id")
		private Long addressId;
		/**
		 * 区
		 */
		@ApiField("area_name")
		private String areaName;
		/**
		 * 市
		 */
		@ApiField("city_name")
		private String cityName;
		/**
		 * 国家
		 */
		@ApiField("country_name")
		private String countryName;
		/**
		 * 行政区划代码
		 */
		@ApiField("division_code")
		private String divisionCode;
		/**
		 * 收件人手机
		 */
		@ApiField("mobile")
		private String mobile;
		/**
		 * 邮政编码
		 */
		@ApiField("post_code")
		private String postCode;
		/**
		 * 省
		 */
		@ApiField("province_name")
		private String provinceName;
		/**
		 * 收件人姓名
		 */
		@ApiField("receiver_name")
		private String receiverName;
		/**
		 * 乡镇街道
		 */
		@ApiField("town_name")
		private String townName;
	

	public String getAddressDetail() {
			return this.addressDetail;
		}
		public void setAddressDetail(String addressDetail) {
			this.addressDetail = addressDetail;
		}
		public Long getAddressId() {
			return this.addressId;
		}
		public void setAddressId(Long addressId) {
			this.addressId = addressId;
		}
		public String getAreaName() {
			return this.areaName;
		}
		public void setAreaName(String areaName) {
			this.areaName = areaName;
		}
		public String getCityName() {
			return this.cityName;
		}
		public void setCityName(String cityName) {
			this.cityName = cityName;
		}
		public String getCountryName() {
			return this.countryName;
		}
		public void setCountryName(String countryName) {
			this.countryName = countryName;
		}
		public String getDivisionCode() {
			return this.divisionCode;
		}
		public void setDivisionCode(String divisionCode) {
			this.divisionCode = divisionCode;
		}
		public String getMobile() {
			return this.mobile;
		}
		public void setMobile(String mobile) {
			this.mobile = mobile;
		}
		public String getPostCode() {
			return this.postCode;
		}
		public void setPostCode(String postCode) {
			this.postCode = postCode;
		}
		public String getProvinceName() {
			return this.provinceName;
		}
		public void setProvinceName(String provinceName) {
			this.provinceName = provinceName;
		}
		public String getReceiverName() {
			return this.receiverName;
		}
		public void setReceiverName(String receiverName) {
			this.receiverName = receiverName;
		}
		public String getTownName() {
			return this.townName;
		}
		public void setTownName(String townName) {
			this.townName = townName;
		}

}



}
